if (typeof notificationHelper === "undefined") {
    notificationHelper = function () {
    };
};

notificationHelper.showNotificationSuccess = function (title, message) {
    setTimeout(function () {
        notificationHelper.showNotification(
            {
                title: title, content: message, shortCutFunction: "success"
            }
        );
    }, 100);
};

notificationHelper.showNotificationFailed = function (title, message) {
    setTimeout(function () {
        notificationHelper.showNotification(
            {
                title: title, content: message, shortCutFunction: "error"
            }
        );
    }, 100);
};

notificationHelper.showNotification = function (options) {
    Messenger({
        extraClasses: 'messenger-fixed messenger-on-right messenger-on-top',
        theme: 'flat'
    }).post({
        message: options.content,
        type: options.shortCutFunction,
        showCloseButton: true
    });
}

notificationHelper.showConfirmation = function (title, messagePart1, messagePart2, callbackName) {
    notificationHelper.showConfirmation(title, messagePart1, messagePart2, '', callbackName)
    var modalHtml = '<div class="modal modal-alert fade" id="modal-confirmation">' +
        '<div class="modal-dialog modal-dialog-centered">' +
        '<div class="modal-content">' +
        '<div class="modal-header">' +
        '<h5 class="modal-title"><i class="ti-check"></i> ' + title + '</h4>' +
        '<button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>' +
        '</div>' +
        '<div class="modal-body mt-3">' +
        '<label class="control-label color-white f-s-19">' +
        messagePart1 +
        ' <b class="menu-red">' + messagePart2 + '</b>' +
        '</label>' +
        '</div>' +
        '<div class="modal-footer">' +
        '<button type="button" class="btn btn-secondary" data-dismiss="modal">' + multilingual.languageSourceObject["Cancel"] + '</button>' +
        '<button type="button" class="btn btn-primary" data-dismiss="modal" onclick="' + callbackName + '"> ' + multilingual.languageSourceObject["Confirm"] + '</button>' +
        '</div>' +
        '</div>' +
        '</div>' +
        '</div>';
    $("#modal-confirmation").remove();
    $("body").append(modalHtml);
    $("#modal-confirmation").modal("show");
}

notificationHelper.showConfirmation = function (title, messagePart1, messagePart2, messagePart3, callbackName) {
    var modalHtml = '<div class="modal modal-alert fade" id="modal-confirmation">' +
        '<div class="modal-dialog modal-dialog-centered">' +
        '<div class="modal-content">' +
        '<div class="modal-header">' +
        '<h5 class="modal-title"><i class="ti-check"></i> ' + title + '</h4>' +
        '<button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>' +
        '</div>' +
        '<div class="modal-body mt-3">' +
        '<label class="control-label color-white f-s-19">' +
        messagePart1 +
        ' <b class="menu-red">' + messagePart2 + '</b>' +
        '</label>' +
        '<p>' +
        messagePart3 +
        '</p>' +
        '</div>' +
        '<div class="modal-footer">' +
        '<button type="button" class="btn btn-secondary" data-dismiss="modal">' + multilingual.languageSourceObject["Cancel"] + '</button>' +
        '<button type="button" class="btn btn-primary" data-dismiss="modal" onclick="' + callbackName + '"> ' + multilingual.languageSourceObject["Confirm"] + '</button>' +
        '</div>' +
        '</div>' +
        '</div>' +
        '</div>';
    $("#modal-confirmation").remove();
    $("body").append(modalHtml);
    $("#modal-confirmation").modal("show");
}