﻿$(document).ready(function () {
    $(".payment-gateway").click(function () {

        $(".payment-gateway").removeClass("active");
        $(this).addClass("active");
        resetForm();
        var paymentGatewayValue = $(this).attr("value");
        $("#PaymentGateway").val(paymentGatewayValue);

        if ($(this).val() == wireTransferPaymentGateway) {
            $("#fundingdetails").show();
            $("#trc20details").hide();
            $("#btcdetails").hide();
            $(".online-transfer").hide();
            $(".wire-transfer").show();
            $(".epay2u").hide();
            //$("#Selectedepay2uBankCardId").rules("remove", "required");
            $("#UploadedWireTransferAttachments").rules("add", "required");
            $("#TransactionDate").rules("add", "required");
            $("#divNote").show();
            $("#PaymentGateway").val(paymentGatewayValue);
            setPaymentCharge(paymentGatewayValue);
            setPaymentAmountCurrency();
            setPspToUsdExchangeRate();
            setHomeToPspExchangeRate();
            calculatePaymentAmount();
        }
        else if ($(this).val() == epay2uPaymentGateway) {
            $("#fundingdetails").show();
            $("#trc20details").hide();
            $("#btcdetails").hide();
            $(".online-transfer").hide();
            $(".wire-transfer").hide();
            $(".epay2u").show();
            //$("#Selectedepay2uBankCardId").rules("add", "required");
            //$("#Selectedepay2uBankCardId").rules("add", {
            //    messages: {
            //        required: multilingual.languageSourceObject["Bank Card is required."]
            //    }
            //});
            $("#UploadedWireTransferAttachments").rules("remove", "required");
            $("#TransactionDate").rules("remove", "required");
            $("#divNote").hide();
            $("#PaymentGateway").val(paymentGatewayValue);
            setPaymentCharge(paymentGatewayValue);
            setPaymentAmountCurrency();
            setPspToUsdExchangeRate();
            setHomeToPspExchangeRate();
            calculatePaymentAmount();
            populateMemberBankCard();
        }
        else if (paymentGatewayValue == trc20PaymentGateway) {
            $(".online-transfer").hide();
            $(".wire-transfer").hide();
            $(".epay2u").hide();
            $("#UploadedWireTransferAttachments").rules("remove", "required");
            $("#TransactionDate").rules("remove", "required");
            $("#divNote").hide();
            $("#fundingdetails").hide();
            $("#trc20details").show();
            $("#btcdetails").hide();
            $("#PaymentGateway").val(paymentGatewayValue);
        }
        else if (paymentGatewayValue == btcPaymentGateway) {
            $(".online-transfer").hide();
            $(".wire-transfer").hide();
            $(".epay2u").hide();
            $("#UploadedWireTransferAttachments").rules("remove", "required");
            $("#TransactionDate").rules("remove", "required");
            $("#divNote").hide();
            $("#fundingdetails").hide();
            $("#trc20details").hide();
            $("#btcdetails").show();
            $("#PaymentGateway").val(paymentGatewayValue);
        }
        else {
            $("#fundingdetails").show();
            $("#trc20details").hide();
            $("#btcdetails").hide();
            $(".online-transfer").hide();
            $(".wire-transfer").hide();
            $(".epay2u").hide();
            //$("#Selectedepay2uBankCardId").rules("remove", "required");
            $("#UploadedWireTransferAttachments").rules("remove", "required");
            $("#TransactionDate").rules("remove", "required");
            $("#divNote").hide();
            $("#PaymentGateway").val(paymentGatewayValue);
            setPaymentCharge(paymentGatewayValue);
            setPaymentAmountCurrency();
            setPspToUsdExchangeRate();
            setHomeToPspExchangeRate();
            calculatePaymentAmount();
        }
    });

    $("#ActualAmountCredited").change(function () {
        calculatePaymentAmount();
    });

    $("#HomeBasedFundingCurrencyId").change(function () {
        $(".home-base-currency-code").text($(this).find("option:selected").text());
        setHomeToPspExchangeRate();
        calculatePaymentAmount();
    });

    function calculatePaymentAmount() {
        var homeBasedCurrencyId = $("#HomeBasedFundingCurrencyId").val();
        var usdBasedAmount = parseFloat($("#ActualAmountCredited").val()) || 0;
        var homebasedAmount = ConvertUsdBasedAmountToHomeAmount(homeBasedCurrencyId, usdBasedAmount);
        $("#HomeBasedFundingAmount").val(roundUp(homebasedAmount));
        calculatePaymentCharge();
        calculateTotalPayment();

        $("#button-submit").prop("disabled", false);
    };

    function ConvertUsdBasedAmountToHomeAmount(homeBasedCurrencyId, usdBasedAmount) {
        var pspAmount;

        //convert from usd to psp settlement
        if (pspSettlementCurrencyId != usdCurrencyId) {
            if (pspToUsdExchangeRate == null) {
                pspAmount = 0;
            }
            else if (pspToUsdExchangeRate.IsReversed) {
                pspAmount = usdBasedAmount / pspToUsdExchangeRate.BuyRate;
            }
            else {
                pspAmount = usdBasedAmount * pspToUsdExchangeRate.SellRate;
            }
        }
        else {
            pspAmount = usdBasedAmount;
        }

        //convert from psp settlement to home currency
        var homeBasedAmount;
        if (homeBasedCurrencyId != pspSettlementCurrencyId) {
            if (homeToPspExchangeRate == null) {
                homeBasedAmount = 0;
            }
            else if (homeToPspExchangeRate.IsReversed) {
                homeBasedAmount = pspAmount / homeToPspExchangeRate.BuyRate;
            }
            else {
                
                homeBasedAmount = pspAmount * homeToPspExchangeRate.SellRate;
            }
        }
        else {
            homeBasedAmount = pspAmount;
        }

        return roundUp(homeBasedAmount);
    }

    function calculatePaymentCharge() {
        var homeBasedAmount = parseFloat($("#HomeBasedFundingAmount").val());
        if (homeBasedAmount > 0) {
            var paymentCharge = homeBasedAmount * (paymentChargeInPercentage / 100);
            if (paymentCharge < paymentChargeInFixedAmount) {
                paymentCharge = paymentChargeInFixedAmount;
            }
            $("#PaymentCharges").val(roundUp(paymentCharge));
        }
        else {
            $("#PaymentCharges").val("0");
        }
    }

    function calculateTotalPayment() {
        var paymentCharges = parseFloat($("#PaymentCharges").val());
        var netPayment = parseFloat($("#HomeBasedFundingAmount").val());
        var totalPayment = netPayment + paymentCharges;
        $("#total-payment-amount").val(roundUp(totalPayment));
    }
});