<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['v1/transfer_list'] = 'bank/transfer_list';
$route['v1/banklist'] = 'bank/bank_list';
$route['v1/bill/bundle'] = 'bill/bundle';
$route['v1/bill/cablebundle'] = 'bill/cablebundle';
$route['v1/bank/accountname'] = 'bank/accountname';
$route['v1/bank/doubleconfirmstatus'] = 'bank/doubleconfirmstatus';
$route['v1/bank/transaction/(:any)'] = 'bank/transaction/$1/';
$route['v1/transfer/init'] = 'transfer/transfer';
$route['v1/transfer/local'] = 'transfer/local_transfer';
$route['v1/bill/purchase'] = 'bill/purchase';
$route['v1/bill/cablepurchase'] = 'bill/cablepurchase';
$route['v1/bill/transactions'] = 'bill/transactions';
$route['v1/init'] = 'setup/init';
$route['v1/init_multiple'] = 'setup/init_multiple';
$route['v1/reset'] = 'corporatebanking/reset_password';
$route['v1/reset_pin'] = 'corporatebanking/reset_pin';
$route['v1/forgot'] = 'corporatebanking/forgot_password';
$route['v1/forgot_pin'] = 'corporatebanking/forgot_pin';
$route['v1/transaction_otp'] = 'corporatebanking/transaction_otp';
$route['v1/update_profile'] = 'corporatebanking/update_profile';
$route['v1/account_stats'] = 'setup/account_stats';
$route['v1/newbusinessaccount'] = 'setup/newbusinessaccount';
$route['v1/confirmbusinessteam'] = 'setup/confirmbusinessteam';
$route['v1/getnewbusinessteam/(:any)/(:any)'] = 'setup/getnewbusinessteam/$1/$2/';
$route['v1/newbusinessactivate/(:any)'] = 'setup/newbusinessactivate/$1/';
$route['v1/new'] = 'corporatebanking/newaccount';
$route['v1/transaction_summary'] = 'corporatebanking/transaction_summary';
$route['v1/alllog'] = 'corporatebanking/alllog';
$route['v1/all_approval/(:any)'] = 'corporatebanking/all_approval/$1/';
$route['v1/pending_approval'] = 'corporatebanking/pending_approval';
$route['v1/role_list'] = 'corporatebanking/role_list';
$route['v1/role_action'] = 'corporatebanking/role_action';
$route['v1/beneficiary_action'] = 'corporatebanking/beneficiary_action';
$route['v1/transaction_statement'] = 'corporatebanking/transaction_statement';
$route['v1/request_token'] = 'corporatebanking/request_token';
$route['v1/getbvn'] = 'utility/bvn';

$route['v1/two_2fa'] = 'corporatebanking/TWO_2FA';

$route['v1/admin/cloud_cron'] = 'admin/cloud_cron';
$route['v1/admin/cloud_init'] = 'admin/cloud_init';
$route['v1/admin/all_transfer'] = 'admin/all_transfer';
$route['v1/admin/all_bill'] = 'admin/all_bill';
$route['v1/admin/all_business'] = 'admin/all_business';
$route['v1/admin/all_business_application'] = 'admin/all_business_application';
$route['v1/admin/all_customer_application'] = 'admin/all_customer_application';

$route['v1/admin/view_bill'] = 'corporatebanking/view_bill';
$route['v1/deposit_webhook'] = 'webhook/deposit';

$route['v1/application_otp'] = 'application/application_otp';
$route['v1/application_business/(:any)'] = 'application/application_business/$1/';

$route['v1/admin/change_application_status/(:any)'] = 'admin/change_application_status/$1/';
$route['v1/application_cron'] = 'application/application_cron';
$route['v1/application_submit'] = 'application/application_submit';
$route['v1/application_team/(:any)'] = 'application/application_team/$1/';
$route['v1/application_contact/(:any)'] = 'application/application_contact/$1/';
$route['v1/application_director/(:any)'] = 'application/application_director/$1/';
$route['v1/application_document'] = 'application/application_document';

$route['v1/admin/single_business_application/(:any)'] = 'admin/single_business_application/$1/';
$route['v1/admin/single_customer_application/(:any)'] = 'admin/single_customer_application/$1/';

$route['v1/personal/application_otp'] = 'personal/application_otp';
$route['v1/personal/application_personal/(:any)'] = 'personal/application_personal/$1/';
$route['v1/personal/application_contact/(:any)'] = 'personal/application_contact/$1/';
$route['v1/personal/application_director/(:any)'] = 'personal/application_director/$1/';
$route['v1/personal/application_document/(:any)/(:any)/(:any)'] = 'personal/application_document/$1/$2/$3/';


$route['default_controller'] = 'api';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
