<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= $title; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style type="text/css">
        body {
            margin-top: 20px;
            background: #f9f9f9;
            font-family: Arial, sans-serif;
        }

        .mail-success {
            text-align: center;
            background: #fff;
            border-top: 1px solid #eee;
            padding: 40px 20px;
        }

        .mail-success .success-inner {
            display: block;
            text-align: left;
            max-width: 600px;
            margin: auto;
            background: #fff;
        }

        .mail-success .success-inner h1 {
            font-size: 100px;
            text-shadow: 3px 5px 2px #3333;
            color: #FD6C01;
            font-weight: 700;
            margin: 0;
        }

        .mail-success .success-inner h2 span {
            display: block;
            font-size: 22px;
            color: #333;
            font-weight: 600;
            margin-top: 10px;
        }

        .mail-success .success-inner p {
            padding: 20px 0;
            font-size: 16px;
            color: #555;
        }

        .footer {
            margin-top: 60px;
            font-size: 13px;
            color: #888;
            text-align: center;
        }
    </style>
</head>
<body>

    <!-- Logo -->
    <center>
        <img style="width: 200px;" src="https://qa.atomafrica.tech/WestonCharis/Web/images/logo.png" alt="Logo">
    </center>

    <!-- Message Body -->
    <section class="mail-success section">
        <div class="success-inner">
            <h2><i class="fa fa-envelope"></i><span>Dear <?= $name; ?>,</span></h2>
            <p><?= $message; ?></p>

            <?php if ($linkstatus == 1): ?>
                <!-- ✅ Big Inline Button -->
                <p style="text-align: center;">
                    <a href="<?= $link; ?>" target="_blank"
                       style="display: inline-block; background-color: #FD6C01; color: #fff; text-decoration: none; padding: 14px 28px; font-size: 16px; font-weight: bold; border-radius: 6px; font-family: Arial, sans-serif; margin-top: 20px;">
                        <?= $linktext; ?>
                    </a>
                </p>
            <?php endif; ?>

            <!-- Footer -->
            <div class="footer">
                Weston-Charis MFB &#169;2025
            </div>
        </div>
    </section>

</body>
</html>
