<?
namespace App\Controllers\v1;
use CodeIgniter\Controller;
use App\Libraries\Email;
use App\Libraries\Config;

use App\Libraries\Ebulksms;
class Corporatebanking extends BaseController
{
		protected $helpers = ["form"];
		public function __construct()
		{
				date_default_timezone_set("Africa/Lagos");
				$this->db = db_connect();


		$config         = new \Config\Encryption();
$config->driver = 'OpenSSL';

// Your CI3's 'encryption_key'
//https://www.convertstring.com/EncodeDecode/HexEncode
$config->key = hex2bin(PASSWORD_ENCRYPT_KEY);
// Your CI3's 'cipher' and 'mode'
$config->cipher = 'AES-128-CBC';

$config->rawData        = false;
$config->encryptKeyInfo = 'encryption';
$config->authKeyInfo    = 'authentication';

$this->encrypter = \Config\Services::encrypter($config,false);




		}
	public function reset_pin()
		{

				try
				{

						$Email = $this
								->request
								->getVar('Email');
						$this->ValidateInputField("Email", $Email);
						
						        $this->WebLog("Password Reset",$Email );

						$OTP = $this
								->request
								->getVar('OTP');
						$this->ValidateInputField("OTP", $OTP);

						$New_Password = $this
								->request
								->getVar('New_Password');
						$this->ValidateInputField("New_Password", $New_Password);


if($OTP != "create_new_pin"){
						$query = $this
								->db
								->query("SELECT id,auth,account,bankname,email,FirstName FROM business WHERE email = '$Email' AND forgot_pass='$OTP' ");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('No account found / Invalid OTP');
						}
}else{
    	$query = $this
								->db
								->query("SELECT id,auth,account,bankname,email,FirstName FROM business WHERE id = '$Email' ");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('No account found');
						}
}
						
						
						
	                            $this->data["to"] = $row->email;
								$this->data["name"] = $row->FirstName;
								$this->data["title"] = "Pin Reset";
								$this->data["message"] = "You have successfully reset your pin on Sulspap MFB";
								$this->data["linkstatus"] = 0;
								$this->data["link"] = "";
								$this->data["linktext"] = "";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
								
								
							

						$Updatequery = $this
								->db
								->query("UPDATE business SET forgot_pass='', pin='$New_Password' WHERE id = '$row->id'");


						return $this
								->response
								->setJSON(['error' => false, 'message' => 'Pin reset successfully!']);
						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}
		public function reset_password()
		{

				try
				{

						$Email = $this
								->request
								->getVar('Email');
						$this->ValidateInputField("Email", $Email);
						
						        $this->WebLog("Password Reset",$Email );

						$OTP = $this
								->request
								->getVar('OTP');
						$this->ValidateInputField("OTP", $OTP);

						$New_Password = $this
								->request
								->getVar('New_Password');
						$this->ValidateInputField("New_Password", $New_Password);

						$query = $this
								->db
								->query("SELECT id,auth,account,bankname,email,FirstName FROM business WHERE email = '$Email' AND forgot_pass='$OTP' ");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('No account found / Invalid OTP');
						}
						
						
						
						
	                            $this->data["to"] = $row->email;
								$this->data["name"] = $row->FirstName;
								$this->data["title"] = "Password Reset";
								$this->data["message"] = "You have successfully reset your password on Sulspap MFB";
								$this->data["linkstatus"] = 0;
								$this->data["link"] = "";
								$this->data["linktext"] = "";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
								
								
								         $ciphertext = base64_encode($this->encrypter->encrypt($New_Password));

						$Updatequery = $this
								->db
								->query("UPDATE business SET forgot_pass='', password='$ciphertext' WHERE id = '$row->id'");

						return $this
								->response
								->setJSON(['error' => false, 'message' => 'Password reset successfully!']);
						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}
		
		
		  public function transaction_summary()
    {

        try
        {
          
          	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
			
						$auth = $headers["X-Auth-Signature"];
        $this->WebLog("Transaction Summary",$auth );

            $numberOfItems = $this
                ->request
                ->getVar('numberOfItems');
            $this->ValidateInputField("numberOfItems", $numberOfItems);
            
            
              $query = $this
                ->db
                ->query("SELECT * FROM business WHERE auth = '$auth'   ORDER BY id DESC ");

            $row = $query->getRow();
     $Transactions = $query->getResult();
            if (!isset($row))
            {
                throw new \Exception('invalid access');
            }
            
            $myQuery = "" ;
            
                  $StartDate = $this->request->getVar('StartDate');
              $EndDate = $this->request->getVar('EndDate');   
               
            if((!isset($StartDate)) ){
         $myQuery = MAIN_SERVER_BASE_URL.'api/Account/GetTransactions/2?authtoken='.IS_BANKONE_TOKEN_LIVE.'&accountNumber='.$row->account.'&institutionCode='.IS_INSTITUTION_CODE.'&numberOfItems='.$numberOfItems ;
            }else if($StartDate == ""){
           $myQuery = MAIN_SERVER_BASE_URL.'api/Account/GetTransactions/2?authtoken='.IS_BANKONE_TOKEN_LIVE.'&accountNumber='.$row->account.'&institutionCode='.IS_INSTITUTION_CODE.'&numberOfItems='.$numberOfItems ;    
            }else{
            //not null and not empty
            //check if is valid
            if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$StartDate)){
               throw new \Exception('start date format should be DD-MM-YYYY');   
            }else{
            $old_date_timestamp = strtotime($StartDate);
            $StartDate = date('Y-m-d', $old_date_timestamp);  
           if($EndDate == "" ){
             $EndDate = date('Y-m-d', $old_date_timestamp); 
            }else{
              if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$EndDate)){
               throw new \Exception('end date format should be DD-MM-YYYY');   
            }else{
                $old_date_timestamp = strtotime($EndDate);
            $EndDate = date('Y-m-d', $old_date_timestamp);    
            }
            }
            }
            
           $myQuery = MAIN_SERVER_BASE_URL.'api/Account/GetTransactions/2?authtoken='.IS_BANKONE_TOKEN_LIVE.'&accountNumber='.$row->account.'&fromDate='.$StartDate.'&toDate='.$EndDate.'&institutionCode='.IS_INSTITUTION_CODE.'&numberOfItems='.$numberOfItems ; 
            
            }
 
 
 
 
 
   $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $myQuery,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => '{
       
}',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ) ,
        ));

        $response = curl_exec($curl);
   $data = json_decode($response);
                curl_close($curl);
                $IsSuccessful = $data->IsSuccessful;
                 $Message = $data->Message;
 if($IsSuccessful){
 
 
            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'Transactions' => $Message ]);
           
 }else{
       throw new \Exception('no data');
 }
           
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }
    
    
      public function transaction_statement()
    {

        try
        {
          
          	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
			
						$auth = $headers["X-Auth-Signature"];
        $this->WebLog("Account Statement",$auth );

            
              $query = $this
                ->db
                ->query("SELECT * FROM business WHERE auth = '$auth'   ORDER BY id DESC ");

            $row = $query->getRow();
     $Transactions = $query->getResult();
            if (!isset($row))
            {
                throw new \Exception('invalid access');
            }
            
            $myQuery = "" ;
            
                  $StartDate = $this->request->getVar('StartDate');
              $EndDate = $this->request->getVar('EndDate');   
               
            if((!isset($StartDate)) ){
      $StartDate = date("Y-m-d") ;  
                  $EndDate = date("Y-m-d");
            }else if($StartDate == ""){
        $StartDate = date("Y-m-d") ;  
                  $EndDate = date("Y-m-d"); 
            }else{
            //not null and not empty
            //check if is valid
            if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$StartDate)){
               throw new \Exception('start date format should be DD-MM-YYYY');   
            }else{
            $old_date_timestamp = strtotime($StartDate);
            $StartDate = date('Y-m-d', $old_date_timestamp);  
           if($EndDate == "" ){
             $EndDate = date('Y-m-d', $old_date_timestamp); 
            }else{
              if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$EndDate)){
               throw new \Exception('end date format should be DD-MM-YYYY');   
            }else{
                $old_date_timestamp = strtotime($EndDate);
            $EndDate = date('Y-m-d', $old_date_timestamp);    
            }
            }
            }
            
          
            }
 
 
 
  $myQuery = MAIN_SERVER_BASE_URL.'api/Account/GenerateAccountStatement/2?authtoken='.IS_BANKONE_TOKEN_LIVE.'&accountNumber='.$row->account.'&institutionCode='.IS_INSTITUTION_CODE.'&fromDate='.$StartDate.'&toDate='.$EndDate.'&isPdf=true&showSerialNumber=true&showTransactionDate=true&showReversedTransactions=true';
 
   $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $myQuery,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => '{
       
}',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ) ,
        ));

        $response = curl_exec($curl);
   $data = json_decode($response);
                curl_close($curl);
                $IsSuccessful = $data->IsSuccessful;
                 $IsSuccessful = $data->Message;
 if($IsSuccessful){
 
 
   # Define the Base64 string of the PDF file
$b64 = $data->Message;

# Decode the Base64 string, making sure that it contains only valid characters
$bin = base64_decode($b64, true);

# Perform a basic validation to make sure that the result is a valid PDF file
# Be aware! The magic number (file signature) is not 100% reliable solution to validate PDF files
# Moreover, if you get Base64 from an untrusted source, you must sanitize the PDF contents
if (strpos($bin, '%PDF') !== 0) {
    throw new \Exception('Missing the PDF file signature');
}

# Write the PDF contents to a local file
$t=time()."".$this->random_password().'.pdf';
 
file_put_contents('../statement/'.$t, $bin);
 
 
            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Your Account Statement is ready. please wait!', 'Source' => $t]);
           
 }else{
       throw new \Exception('no data');
 }
           
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }
		
			public function TWO_2FA()
		{

				try
				{


	
						$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
						
					

						$auth = $headers["X-Auth-Signature"];
						
						        $this->WebLog("2FA Confirmation",$auth );
						
						  $token = $this
                ->request
                ->getVar('token');
            $this->ValidateInputField("token", $token);
				
							
						  $uid = $this
                ->request
                ->getVar('uid');
            $this->ValidateInputField("uid", $uid);
            
            
							$query = $this
								->db
								->query("SELECT id,email,auth,two_2fa FROM business WHERE  auth = '$auth' AND id='$uid'");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('Invalid Operation!');
						}
						
if($row->two_2fa == ""){
   	throw new \Exception('Invalid Secret Key!'); 
}

                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://stanlytics.com/v1/etoken/etoken_confirm',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => '{
   "token": "' .$token. '",
   "server": "sulspap",
   "auth": "' .$row->id. '",
"secret": "' . $row->two_2fa. '"
}',
                            CURLOPT_HTTPHEADER => array(
                                'Content-Type: application/json'
                            ) ,
                        ));

                        $response = curl_exec($curl);
                        $data = json_decode($response);
                        curl_close($curl);

                        $status = $data->status;

						return $this
								->response
								->setJSON(['error' => false, 'success' => $status]);

						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}


			public function transaction_otp()
		{

				try
				{


	
						$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
							  $uid = $this
                ->request
                ->getVar('uid');
            $this->ValidateInputField("uid", $uid);
            
            
            	  $TokenType = $this
                ->request
                ->getVar('TokenType');
						
					

						$auth = $headers["X-Auth-Signature"];
						
						        $this->WebLog("Generate Transaction OTP",$auth );
				
						
							$query = $this
								->db
								->query("SELECT id,email,pin FROM business WHERE  auth = '$auth' AND id = '$uid' ");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('Invalid Operation!');
						}
						

				
						$query = $this
								->db
								->query("SELECT id,auth,account,bankname,email,FirstName,security,Mobile,getemail,getsms,getwhatsapp,pin FROM business WHERE email = '$row->email'");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('No account found!');
						}
						
						//Create authorisation
						if($TokenType == "Email"){
							if($row->security == 0){
						$accessToken = rand(100000, 999999);
						
						

						$Updatequery = $this
								->db
								->query("UPDATE business SET forgot_pass='$accessToken' WHERE id = '$row->id'");
								
								$OtpMessage = "Your Transaction OTP code is " . $accessToken;
							if($row->getemail == 1){
								
								 $this->data["to"] = $row->email;
								$this->data["name"] = $row->FirstName;
								$this->data["title"] = "Secure OTP Code";
								$this->data["message"] = $OtpMessage;
								$this->data["linkstatus"] = 0;
								$this->data["link"] = "";
								$this->data["linktext"] = "";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
							}	
								
								
								
								
								
								//SMS
	                            $API_Ht = new Ebulksms();
	                            
								if($row->getsms == 1){
						
                     
                       $OrderResponse =      $API_Ht->SendSMS("OTP",$row->Mobile,$OtpMessage);
								}

								
								//WHATSAPP
							
								if($row->getwhatsapp == 1){
						
                       $OrderResponse =      $API_Ht->SendWHATSAPP("OTP",$row->Mobile,$OtpMessage);
								}

									
								
								
								
								$messages = "An OTP have been send to your email!" ;
								}else{
								 		$messages = "Please kindly use your software token!" ;  
								 		$accessToken = "SoftwareToken" ;
								}
						}else{
						    		$messages = "Please press your 6 Digit PIN !" ;  
						   $accessToken =  $row->pin ;
						}		

				

						return $this
								->response
								->setJSON(['error' => false, 'message' => $messages, 'OTP' => $accessToken]);

						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}


		public function forgot_password()
		{

				try
				{

						$Email = $this
								->request
								->getVar('Email');
						$this->ValidateInputField("Email", $Email);
				        $this->WebLog("Forgot Password",$Email );
						$query = $this
								->db
								->query("SELECT id,auth,account,bankname,email,FirstName,Mobile FROM business WHERE email = '$Email' ");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('No account found!');
						}
						//Create authorisation
						$accessToken = rand(100000, 999999);

						$Updatequery = $this
								->db
								->query("UPDATE business SET forgot_pass='$accessToken' WHERE id = '$row->id'");
								
								 $this->data["to"] = $row->email;
								$this->data["name"] = $row->FirstName;
								$this->data["title"] = "Secure Password Reset OTP";
								$this->data["message"] = "You initiate a password reset. Your OTP code is " . $accessToken;
								$this->data["linkstatus"] = 0;
								$this->data["link"] = "";
								$this->data["linktext"] = "";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
								//SMS
								$curl = curl_init();
$data = array("api_key" => "TL1DoRU7EX7wMVmrAsRwdNOjl0zgM9OBSVkeSJYyXvNYbIcyks19a0lKF7wBp7", "to" => "".$row->Mobile,  "from" => "VendPock",
"sms" => "".$this->data["message"],  "type" => "plain",  "channel" => "generic" );

$post_data = json_encode($data);

curl_setopt_array($curl, array(
CURLOPT_URL => "https://api.ng.termii.com/api/sms/send",
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 0,
CURLOPT_FOLLOWLOCATION => true,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_POSTFIELDS => $post_data,
CURLOPT_HTTPHEADER => array(
"Content-Type: application/json"
),
));

$response_sms = curl_exec($curl);

curl_close($curl);
	

				

						return $this
								->response
								->setJSON(['error' => false, 'message' => 'OTP have been send to your email!',  'Email' => $Email]);

						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}

	
		public function forgot_pin()
		{

				try
				{

						$Email = $this
								->request
								->getVar('Email');
						$this->ValidateInputField("Email", $Email);
				        $this->WebLog("Forgot Password",$Email );
						$query = $this
								->db
								->query("SELECT id,auth,account,bankname,email,FirstName,Mobile FROM business WHERE email = '$Email' ");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('No account found!');
						}
						//Create authorisation
						$accessToken = rand(100000, 999999);

						$Updatequery = $this
								->db
								->query("UPDATE business SET forgot_pass='$accessToken' WHERE id = '$row->id'");
								
								 $this->data["to"] = $row->email;
								$this->data["name"] = $row->FirstName;
								$this->data["title"] = "Secure Pin Reset OTP";
								$this->data["message"] = "You initiate a pin reset. Your OTP code is " . $accessToken;
								$this->data["linkstatus"] = 0;
								$this->data["link"] = "";
								$this->data["linktext"] = "";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
								//SMS
								$curl = curl_init();
$data = array("api_key" => "TL1DoRU7EX7wMVmrAsRwdNOjl0zgM9OBSVkeSJYyXvNYbIcyks19a0lKF7wBp7", "to" => "".$row->Mobile,  "from" => "VendPock",
"sms" => "".$this->data["message"],  "type" => "plain",  "channel" => "generic" );

$post_data = json_encode($data);

curl_setopt_array($curl, array(
CURLOPT_URL => "https://api.ng.termii.com/api/sms/send",
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 0,
CURLOPT_FOLLOWLOCATION => true,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_POSTFIELDS => $post_data,
CURLOPT_HTTPHEADER => array(
"Content-Type: application/json"
),
));

$response_sms = curl_exec($curl);

curl_close($curl);
	

				

						return $this
								->response
								->setJSON(['error' => false, 'message' => 'OTP have been send to your email!',  'Email' => $Email]);

						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}


		public function update_profile()
		{

				try
				{
						
						
						$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
						
					

						$auth = $headers["X-Auth-Signature"];
        $this->WebLog("Account Update",$auth );
        
        
        	$actualSender_id = $this
								->request
								->getVar('actualSender_id');
						$this->ValidateInputField("actualSender_id", $actualSender_id);



                    	$getsms = $this
								->request
								->getVar('getsms');
						$this->ValidateInputField("getsms", $getsms);
						
							$getemail= $this
								->request
								->getVar('getemail');
						$this->ValidateInputField("getemail", $getemail);
						
							$getwhatsapp = $this
								->request
								->getVar('getwhatsapp');
						$this->ValidateInputField("getwhatsapp", $getwhatsapp);
						
						
						

						$Mobile = $this
								->request
								->getVar('Mobile');
						$this->ValidateInputField("Mobile", $Mobile);

						$FirstName = $this
								->request
								->getVar('FirstName');
						$this->ValidateInputField("FirstName", $FirstName);

						$LastName = $this
								->request
								->getVar('LastName');
						$this->ValidateInputField("LastName", $LastName);

						$BusinessState = $this
								->request
								->getVar('BusinessState');
						$this->ValidateInputField("BusinessState", $BusinessState);

						$Fund_Transfer_WebHook = $this
								->request
								->getVar('Fund_Transfer_WebHook');
					//	$this->ValidateInputField("Fund_Transfer_WebHook", $Fund_Transfer_WebHook);

		$BusinessAddress = $this
								->request
								->getVar('BusinessAddress');
						$this->ValidateInputField("BusinessAddress", $BusinessAddress);
						
						
						$Virtual_Account_WebHook = $this
								->request
								->getVar('Virtual_Account_WebHook');
					//	$this->ValidateInputField("Virtual_Account_WebHook", $Virtual_Account_WebHook);

						$Bill_WebHook = $this
								->request
								->getVar('Bill_WebHook');
					//	$this->ValidateInputField("Bill_WebHook", $Bill_WebHook);
						
						
							$security = $this
								->request
								->getVar('security');
							if($security == "")	{
							    $security = 0;
							}
								

						$query = $this
								->db
								->query("SELECT id,email FROM business WHERE  id = '$actualSender_id'");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('Invalid Operation!');
						}
						else
						{



	                            $this->data["to"] = $row->email;
								$this->data["name"] = $FirstName;
								$this->data["title"] = "Profile Changed";
								$this->data["message"] = "You have successfully updated your business profile on Sulspap MFB.";
								$this->data["linkstatus"] = 0;
								$this->data["link"] = "";
								$this->data["linktext"] = "";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
								
								$Updatequery = $this
										->db
										->query("UPDATE business SET security='$security',getsms='$getsms',getemail='$getemail',getwhatsapp='$getwhatsapp',Mobile='$Mobile',FirstName='$FirstName',LastName='$LastName',BusinessState='$BusinessState',BusinessAddress='$BusinessAddress',Fund_Transfer_WebHook='$Fund_Transfer_WebHook',Virtual_Account_WebHook='$Virtual_Account_WebHook',Bill_WebHook='$Bill_WebHook' WHERE id = '$row->id'");

								return $this
										->response
										->setJSON(['error' => false, 'message' => 'Successfully!']);
						}

						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}


public function random_password() 
{
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
    $password = array(); 
    $alpha_length = strlen($alphabet) - 1; 
    for ($i = 0; $i < 8; $i++) 
    {
        $n = rand(0, $alpha_length);
        $password[] = $alphabet[$n];
    }
    return implode($password); 
}

		public function newaccount()
		{

				try
				{
				    
				 
						$Email = $this
								->request
								->getVar('Email');
						$this->ValidateInputField("Email", $Email);
						        $this->WebLog("New Account Creation",$Email );

						$Password = $this->random_password() ;
						
				


						$Mobile = $this
								->request
								->getVar('Mobile');
						$this->ValidateInputField("Mobile", $Mobile);

						$FirstName = $this
								->request
								->getVar('FirstName');
						$this->ValidateInputField("FirstName", $FirstName);

						$LastName = $this
								->request
								->getVar('LastName');
						$this->ValidateInputField("LastName", $LastName);

						$BusinessState = $this
								->request
								->getVar('BusinessState');
						$this->ValidateInputField("BusinessState", $BusinessState);
		$Access = $this->request->getVar('Access');
						$this->ValidateInputField("Access", $Access);
						
						$Gender = $this
								->request
								->getVar('Gender');
						$this->ValidateInputField("Gender", $Gender);

						$bvn = $this
								->request
								->getVar('bvn');
						$this->ValidateInputField("bvn", $bvn);

						$dob = $this
								->request
								->getVar('dob');
						$this->ValidateInputField("dob", $dob);

						$BusinessAddress = $this
								->request
								->getVar('BusinessAddress');
						$this->ValidateInputField("BusinessAddress", $BusinessAddress);
						
							$CorporateAccountNo = $this
								->request
								->getVar('CorporateAccountNo');
						$this->ValidateInputField("CorporateAccountNo", $CorporateAccountNo);
						
							$CorporateID = $this
								->request
								->getVar('CorporateID');
						$this->ValidateInputField("CorporateID", $CorporateID);
						
					
						

						$OtherName = $this
								->request
								->getVar('OtherName');
						if (!isset($OtherName))
						{
								$OtherName = "";
						}

	$query_p = $this->db->query("SELECT auth FROM business WHERE email = '$Email' LIMIT 1");
						$row_p = $query_p->getRow();
						$multipleAccount = 0 ;
if(isset($row_p)){
    //
    	$multipleAccount = 1 ;
}



                        //check to see if that account exist
                        
                      	$query_y = $this
								->db
								->query("SELECT auth FROM business WHERE account = '$CorporateAccountNo' LIMIT 1");
						$row_y = $query_y->getRow();

//check there is any admin..you can only have one admin
	$query_x = $this
								->db
								->query("SELECT auth FROM business WHERE account = '$CorporateAccountNo' AND access='0'");
						$row_x = $query_x->getRow();
	if ((isset($row_x)) && ($Access == 0))
						{
						  //this mean dont create another admin since admin dey there before 
						  	throw new \Exception('You can only have a single admin account!');
						    
						}


						$query = $this
								->db
								->query("SELECT id FROM business WHERE email = '$Email' AND account = '$CorporateAccountNo'");
						$row = $query->getRow();
						if (!isset($row))
						{

								$t = rand(0, 100) . time() . rand(111, 18834);
								$reference = $t;
								
								if($Access == 0){
								   
								$auth = rand(0, 100) . md5($reference . $Email) . rand(311, 584);
}else{
    //i believe at this point, previous owner most important admin is created before
    	if (!isset($row_y))
						{
					//generate a record if 	is not there
							$auth = rand(0, 100) . md5($reference . $Email) . rand(311, 584);
						}else{
						  	$auth = $row_y->auth ;  
						}
   
}







$curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => MAIN_SERVER_BASE_URL.'api/Account/GetActiveSavingsAccountsByCustomerID/2?authtoken='.IS_BANKONE_TOKEN_LIVE.'&customerId='.$CorporateID,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_POSTFIELDS =>'{
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);
		$data = json_decode($response);
curl_close($curl);
$Account = "" ;
$BusinessName = "";
$balance = "";										
	$Bank = "Sulspap Bank"	;
	$index_reference = 0 ;
if($data){
    $count_index = count($data);
    for($a_c=0 ; $a_c < $count_index ; $a_c++){
        $Account = $data[$a_c]->NUBAN;
        if($Account == $CorporateAccountNo){
           $Account = $data[$a_c]->NUBAN;
$BusinessName = $data[$a_c]->Name;
$balance = $data[$a_c]->Balance->WithdrawableAmount;										
	$Bank = "Sulspap Bank"	; 
            $index_reference = $a_c ;
            break ;
        }
        
    }
}


	
	
	
	
	 $Str = str_replace(' ', '', $BusinessName);
                $shortName = strtoupper(substr($Str, 0, 4)) ; 
						
						if($CorporateAccountNo == $Account)	{	
						    
						    $m_Pin = rand(111111,999999) ;
						    
						             $ciphertext = base64_encode($this->encrypter->encrypt($Password));
								$query = $this
										->db
										->query("INSERT INTO business (id,status,access,index_reference,CorporateID,auth,account,bankname,businessname,shortName,randomstring,email,password,pin,FirstName,LastName,OtherName,Gender,Mobile,bvn,dob,getemail,getsms,BusinessState,BusinessAddress,security,two_2fa,date ) VALUES (NULL,'1','$Access','$index_reference','$CorporateID','$auth','$CorporateAccountNo','$Bank','$BusinessName','$shortName','$reference','$Email','$ciphertext','$m_Pin','$FirstName','$LastName','$OtherName','$Gender','$Mobile','$bvn','$dob','1','0','$BusinessState','$BusinessAddress','0','', NULL)");



if($Access == 0){
	$now = strtotime("now") ;

	$query = $this->db->query("INSERT INTO `virtual` (`id`, `tier`, `platform`, `randomstring`, `auth`,`Type`, `AccountName`, `GatewayCustomerID`, `GatewayCustomerAccountNumber`, `AccountNumber`, `BankName`, `FirstName`, `LastName`, `OtherName`, `Address`, `Gender`, `BVN`, `DateOfBirth`, `PhoneNumber`, `IdentityNumber`, `Email`, `date`,`stamp`) VALUES (NULL,'1','Static','$reference','$auth','Admin','$BusinessName','$CorporateID','','$CorporateAccountNo','$Bank','$FirstName','$LastName','$OtherName','$BusinessAddress','$Gender','$bvn','$dob','$Mobile','','$Email', CURRENT_TIMESTAMP,'$now')");
						


/*
								//Login
								//since you using two curl...dont close
								$curl = curl_init();
								curl_setopt_array($curl, array(
										CURLOPT_URL => 'https://api.vendpocket.com/v1/init',
										CURLOPT_RETURNTRANSFER => true,
										CURLOPT_ENCODING => '',
										CURLOPT_MAXREDIRS => 10,
										CURLOPT_TIMEOUT => 0,
										CURLOPT_FOLLOWLOCATION => true,
										CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
										CURLOPT_CUSTOMREQUEST => 'POST',
										CURLOPT_POSTFIELDS => array(
												'Rehoboth_Api_Email' => $Email,
												'Rehoboth_Api_Password' => $Password
										) ,
								));
								$response = curl_exec($curl);

								$data = json_decode($response);
								$accesscode = $data
										->Authorisation->accesscode;

								$curl = curl_init();
								curl_setopt_array($curl, array(
										CURLOPT_URL => 'https://api.vendpocket.com/v1/virtual/create',
										CURLOPT_RETURNTRANSFER => true,
										CURLOPT_ENCODING => '',
										CURLOPT_MAXREDIRS => 10,
										CURLOPT_TIMEOUT => 0,
										CURLOPT_FOLLOWLOCATION => true,
										CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
										CURLOPT_CUSTOMREQUEST => 'POST',
										CURLOPT_POSTFIELDS => array(
												'FirstName' => $FirstName,
												'LastName' => $LastName,
												'PhoneNumber' => $Mobile,
												'Gender' => $Gender,
												'Email' => $Email,
												'BVN' => $bvn,
												'OtherName' => $OtherName,
												'DateOfBirth' => $dob,
												'Tier' => '1'
										) ,
										CURLOPT_HTTPHEADER => array(
												'X-Auth-Signature: ' . $auth,
												'Authorization: Bearer ' . $accesscode
										) ,
								));

								$response = curl_exec($curl);
								curl_close($curl);
								$data = json_decode($response);
								
								
								
								
								
								
								$Account = $data
										->Virtual->AccountNumber;
								$Bank = $data
										->Virtual->BankName;

								$Updatequery = $this
										->db
										->query("UPDATE business SET account='$Account', bankname='$Bank'  WHERE auth = '$auth'");
								//Create authorisation
								
*/
								$Data = ['auth' => $auth, 'Balance' => $balance, 'AccountNumber' => $Account, 'BankName' => $Bank];
								
								
if($multipleAccount == 0){
    //no previous login. then send login credential
								$this->data["to"] = $Email;
								$this->data["name"] = $FirstName;
								$this->data["title"] = "Account Information";
								$this->data["message"] = "Welcome Onboard <br><br>Please be advised of your Live Credentials' details.<br><br>Email: " . $Email . "<br><br>Password: " . $Password."<br><br>Live URL:  <a href=".PLATFORM_NAME_IBANK."account>".PLATFORM_NAME_IBANK."account</a>" ;
								$this->data["linkstatus"] = 1;
								$this->data["link"] = PLATFORM_NAME_IBANK."account";
								$this->data["linktext"] = "Login";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
}	
								
								
								
									$this->data["to"] ="admin@vendpocket.com";
								$this->data["name"] = $FirstName;
								$this->data["title"] = "New Business Account Information";
								$this->data["message"] = "Welcome Onboard <br><br>Please be advised of your Live Credentials' details.<br><br>Role: Admin<br><br>Email: " . $Email . "<br><br>Password: " . $Password ."<br><br>Live URL:  <a href=".PLATFORM_NAME_IBANK."account>".PLATFORM_NAME_IBANK."account</a>" ;
								$this->data["linkstatus"] = 1;
								$this->data["link"] = PLATFORM_NAME_IBANK."account";
								$this->data["linktext"] = "Login";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
}else{
    		$Data = [ 'Balance' => $balance, 'AccountNumber' => $Account, 'BankName' => $Bank];
								
		$myRole = "";
		if($Access == 1){
		    	$myRole ="Initiator";
		}else if($Access == 2){
		    	$myRole = "Grantor" ;
		}else if($Access == 3){
		    	$myRole = "Viewer" ;
		}
		

								$this->data["to"] = $Email;
								$this->data["name"] = $FirstName;
								$this->data["title"] = "Account Information";
								$this->data["message"] = "Welcome Onboard <br><br>Please be advised of your Live Credentials' details.<br><br>
Role: " . $myRole. "<br><br>Email: " . $Email . "<br><br>Password: " . $Password ;
								$this->data["linkstatus"] = 1;
								$this->data["link"] = PLATFORM_NAME_IBANK;
								$this->data["linktext"] = "Login";

								$myEmail = new Email();
								$myEmail->Normal($this->data);
								
}	

								return $this
										->response
										->setJSON(['error' => false, 'message' => 'Successfully!', 'Data' => $Data]);
						}else{
						 	throw new \Exception('Invalid Corporate ID/Account Number!');   
						}

						}
						else
						{
								throw new \Exception('This account already exist!');
						}

						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}

		public function request_token()
		{

				try
				{


 	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
			
						$auth = $headers["X-Auth-Signature"];
						
						   	$actualSender_id = $this
								->request
								->getVar('actualSender_id');
						$this->ValidateInputField("actualSender_id", $actualSender_id); 
						
					

						$query = $this
								->db
								->query("SELECT * FROM business WHERE auth = '$auth' AND id='$actualSender_id'");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('invalid auth/ no data');
						}
						
	
				
                            
					 
						  $this->data["to"] = "olacoycompany@gmail.com";
                            $this->data["name"] = "Info";
                            $this->data["title"] = "New Token Request";
                            $this->data["message"] = "A new token is requested by ".$row->businessname." <br><br> the user that request it is ".$row->FirstName." ".$row->LastName."<br><br>account number is ".$row->account.", email is ".$row->email;  ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";

                            $myEmail = new Email();
                            $myEmail->Normal($this->data);
					
	

						return $this
								->response
								->setJSON(['error' => false, 'message' => 'Successfully!']);
						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}
		
			public function role_action()
		{

				try
				{


 	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
			
						$auth = $headers["X-Auth-Signature"];
						
						
						        $this->WebLog("Update Access level",$auth );
							$action = $this
								->request
								->getVar('action');
						$this->ValidateInputField("action", $action);
						
							$userid = $this
								->request
								->getVar('userid');
						$this->ValidateInputField("userid", $userid);
						

						$query = $this
								->db
								->query("SELECT * FROM business WHERE auth = '$auth' AND id='$userid'");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('invalid auth/ no data');
						}
						
	
					if($action == 0){
					    //delete
					    
			
					     $Updatequery = $this->db->query("UPDATE business SET status='0' WHERE id = '$row->id'");
					     
					 
						  $this->data["to"] = $row->email;
                            $this->data["name"] = $row->businessname;
                            $this->data["title"] = "Internet Banking Disabled";
                            $this->data["message"] = "<h3><b>Alert</b></h3><br><br>You internet banking login disabled";  ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";

                            $myEmail = new Email();
                            $myEmail->Normal($this->data);
					}else if($action == 1){
					    //reset passwod
					    
					     $pass = rand(123456,999999);
			
                         $Updatequery = $this->db->query("UPDATE business SET password='$pass' WHERE id = '$row->id'");
						
						  $this->data["to"] = $row->email;
                            $this->data["name"] = $row->businessname;
                            $this->data["title"] = "Internet Banking Password Reset";
                            $this->data["message"] = "<h3><b>Password Alert</b></h3><b>Account Number</b><br>".$row->account."<br><b>Account Name</b><br>".$row->businessname."<br><b>Email</b><br>".$row->email."<br><b>New Password</b><br>".$pass  ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";

                            $myEmail = new Email();
                            $myEmail->Normal($this->data);
					}	
						
						
	

						return $this
								->response
								->setJSON(['error' => false, 'message' => 'Successfully!']);
						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}
		
		
		
			public function beneficiary_action()
		{

				try
				{


 	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
			
						$auth = $headers["X-Auth-Signature"];
						
						
						        $this->WebLog("Delete Beneficiary",$auth );
							$action = $this
								->request
								->getVar('action');
						$this->ValidateInputField("action", $action);
						
						

						$query = $this
								->db
								->query("SELECT * FROM business WHERE auth = '$auth'");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('invalid auth/ no data');
						}
						
	
				
					    //delete
					    
			
					     $Updatequery = $this->db->query("DELETE FROM beneficiary WHERE id = '$action'");
					     
					 
						  $this->data["to"] = $row->email;
                            $this->data["name"] = $row->businessname;
                            $this->data["title"] = "Beneficiary Deleted";
                            $this->data["message"] = "<h3><b>Alert</b></h3><br><br>A Beneficiary have been deleted on your internet banking";  ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";

                            $myEmail = new Email();
                            $myEmail->Normal($this->data);
					
						
						
	

						return $this
								->response
								->setJSON(['error' => false, 'message' => 'Successfully!']);
						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}
		
		
		 public function alllog()
    {

        try
        {
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
            
                       $length= $this->request->getVar('length');
                  $StartDate = $this->request->getVar('StartDate');
              $EndDate = $this->request->getVar('EndDate');   
               
            if((!isset($StartDate)) ){
              $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;
            }else if($StartDate == ""){
                $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;  
            }else{
            //not null and not empty
            //check if is valid
            if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$StartDate)){
               throw new \Exception('start date format should be DD-MM-YYYY');   
            }else{
            $old_date_timestamp = strtotime($StartDate);
            $StartDate = date('Y-m-d', $old_date_timestamp)." 00:00:00";  
           if($EndDate == "" ){
             $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59"; 
            }else{
              if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$EndDate)){
               throw new \Exception('end date format should be DD-MM-YYYY');   
            }else{
                $old_date_timestamp = strtotime($EndDate);
            $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59";    
            }
            }
            }
            }

if($length == "0"){
            $query = $this->db->query("SELECT * FROM weblog  ORDER BY id DESC  LIMIT 3 ");
}else{
      $query = $this
                ->db
                ->query("SELECT * FROM weblog WHERE  ((date >= '$StartDate') AND (date <= '$EndDate') )    ORDER BY id DESC  ");
}
                
                

            $row = $query->getRow();

            if (!isset($row))
            {
                throw new \Exception('No Data Found');
            }
            $Transactions = $query->getResult();

            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'Transactions' => $Transactions]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }
    
		
			public function role_list()
		{

				try
				{


 	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
						
			
						$auth = $headers["X-Auth-Signature"];
						        $this->WebLog("Get Access Level List",$auth );

						$query = $this
								->db
								->query("SELECT id,access,auth,account,Mobile,FirstName,LastName,Email FROM business WHERE auth = '$auth'");
						$row = $query->getRow();
						if (!isset($row))
						{
								throw new \Exception('invalid auth');
						}
						
						$Transactions = $query->getResult();
						
						
						
	

						return $this
								->response
								->setJSON(['error' => false, 'message' => 'Successfully!', 'Transactions' => $Transactions]);
						die();
				}
				catch(\Exception $e)
				{
						return $this
								->response
								->setJSON(['error' => true, 'message' => $e->getMessage() ]);
						die();
				}

				//print_r($headers);
				//echo $headers["X-Auth-Signature"] ;
				

				
		}
		
	



     public function all_approval($status)
    {

        try
        {
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
            
             $this->WebLog("Approval List",$auth );
                  $StartDate = $this->request->getVar('StartDate');
              $EndDate = $this->request->getVar('EndDate');   
               
               if($status != 0){
            if((!isset($StartDate)) ){
              $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;
            }else if($StartDate == ""){
                $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;  
            }else{
            //not null and not empty
            //check if is valid
            if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$StartDate)){
               throw new \Exception('start date format should be DD-MM-YYYY');   
            }else{
            $old_date_timestamp = strtotime($StartDate);
            $StartDate = date('Y-m-d', $old_date_timestamp)." 00:00:00";  
           if($EndDate == "" ){
             $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59"; 
            }else{
              if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$EndDate)){
               throw new \Exception('end date format should be DD-MM-YYYY');   
            }else{
                $old_date_timestamp = strtotime($EndDate);
            $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59";    
            }
            }
            }
            }

            $query = $this
                ->db
                ->query("SELECT * FROM pretransfer WHERE  ((date >= '$StartDate') AND (date <= '$EndDate') ) AND auth='$auth'   ORDER BY id DESC  ");
                
               }else{
               $query = $this
                ->db
                ->query("SELECT * FROM pretransfer WHERE   status='0'   AND auth='$auth'   ORDER BY id DESC  ");    
               }

            $row = $query->getRow();

            if (!isset($row))
            {
                throw new \Exception('no data');
            }
            $Transactions = $query->getResult();

            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'Transactions' => $Transactions]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }
    
    
      public function pending_approval()
    {

        try
        {
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
               $this->WebLog("Pending Approval List",$auth );
          
            $query = $this
                ->db
                ->query("SELECT * FROM pretransfer WHERE  status='0' OR status='3' AND auth='$auth'    ORDER BY id DESC  ");

            $row = $query->getRow();

            if (!isset($row))
            {
                throw new \Exception('no data');
            }
            $Transactions = $query->getResult();

            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'Transactions' => $Transactions]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }
    
     public function allcustomer()
    {



      
        try
        {
          	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
          
            
            $query = $this
            ->db
            ->query("SELECT id,account,CorporateID,businessname,FirstName,LastName,OtherName,Mobile,email,access FROM business  ORDER BY id DESC ");
   
        $row = $query->getRow() ;
        if (!isset($row))
        {
            throw new \Exception('no data');
        }
        $Transactions = $query->getResult();
     



            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'Transactions' => $Transactions]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ,'Transactions' => []]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

    public function view_bill()
    {



      
        try
        {
          	$headers_input = $this->request->headers();
						$myHeader = new Config();
					$headers =	$myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
             $this->WebLog("View Utility Bill List",$auth );
         $StartDate = $this->request->getVar('StartDate');
              $EndDate = $this->request->getVar('EndDate');   
               
            if((!isset($StartDate)) ){
              $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;
            }else if($StartDate == ""){
                $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;  
            }else{
            //not null and not empty
            //check if is valid
            if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$StartDate)){
               throw new \Exception('start date format should be DD-MM-YYYY');   
            }else{
            $old_date_timestamp = strtotime($StartDate);
            $StartDate = date('Y-m-d', $old_date_timestamp)." 00:00:00";  
           if($EndDate == "" ){
             $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59"; 
            }else{
              if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$EndDate)){
               throw new \Exception('end date format should be DD-MM-YYYY');   
            }else{
                $old_date_timestamp = strtotime($EndDate);
            $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59";    
            }
            }
            }
            }
            
            $query = $this
            ->db
            ->query("SELECT * FROM bundle_purchase WHERE  ((date >= '$StartDate') AND (date <= '$EndDate') ) ORDER BY id DESC ");
   
        $row = $query->getRow() ;
        if (!isset($row))
        {
            throw new \Exception('no data');
        }
        $Transactions = $query->getResult();
     



            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'Transactions' => $Transactions]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ,'Transactions' => []]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

   
	  public function ValidateInputField($Field, $Value)
    {
        if ((!isset($Field)) || ($Value == "") || (strpos($Value, "'") !== false))
        {
            throw new \Exception($Field . ' is mandatory');
        }
    }
		
		
			  public function weblog($pagetitle,$auth){
    $agent = $this->request->getUserAgent();
    $plat = $agent->getPlatform();
   $ip= $this->request->getIPAddress() ;
 
           if ($agent->isBrowser()) {
    $agent = $agent->getBrowser() . ' ' . $agent->getVersion();
} elseif ($agent->isRobot()) {
  $agent = $agent->getRobot();
} elseif ($agent->isMobile()) {
      $agent = $agent->getMobile();
} else {
    $agent= 'Unidentified User Agent';
}

        
         		$query = $this->db->query("INSERT INTO `weblog` (`id`, `channel`, `userid`, `browser`, `platform`, `ipaddress`, `description`, `date`) VALUES (NULL, 'Client', '$auth', '$agent', '$plat', '$ip', '$pagetitle', current_timestamp())");
    }
    

	

}

