<?
namespace App\Controllers\v1;
use CodeIgniter\Controller;
use App\Libraries\Email;
use App\Libraries\Config;
class Bank extends BaseController
{
    protected $helpers = ["form"];
    public function __construct()
    {
        date_default_timezone_set("Africa/Lagos");
        $this->db = db_connect();

    }


    
  public function doubleconfirmstatus()
    {

        try
        {
            
            
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            
              $transaction_id = $this
                ->request
                ->getVar('transaction_id');
            $this->ValidateInputField("transaction_id", $transaction_id);
            
                  $status = $this
                ->request
                ->getVar('status');
            $this->ValidateInputField("status", $status);
            
            
              $Updatequery = $this
                            ->db
                            ->query("UPDATE  pretransfer  SET status='$status' WHERE id ='$transaction_id'");
            
          

            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Updated Successfully!']);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

    public function bank_list()
    {

        try
        {
            
            
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
           
           // $auth = "34d2c820a315bc8ffb5086a433f0075f22426" ;
            //
            
            

            if (DEFAULTGATEWAY_TRANSFER == 0)
            {
                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.mybankone.com/thirdpartyapiservice/APIService/BillsPayment/GetCommercialBanks/' . IS_BANKONE_TOKEN_LIVE,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                    ) ,
                ));

                $response = curl_exec($curl);
                $data = json_decode($response, true);
                curl_close($curl);
            }
            else if (DEFAULTGATEWAY_TRANSFER == 1)
            {

                $data = [

                ];
                // print_r(    $data);
                // die() ;
                $data_string = json_encode($data);
                $bearer = $this->monnify_loginauthentication();
                $ch = curl_init("https://api.monnify.com/api/v1/banks");
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer " . $bearer, "Content-Type: application/json", "Content-Length: " . strlen($data_string) , ]);

                $response = curl_exec($ch);
                $data = json_decode($response);
                curl_close($ch);
                $data = $data->responseBody;

            }
            $count = count($data);

            $query_settings = $this
                ->db
                ->query("SELECT * FROM settings WHERE  name = 'Bank_Addition_NAMING_CRON'");
            $row_settings = $query_settings->getRow();
            $cron_date = $row_settings->value;

            $newDate = date("Y-m-d H:i:s");
            $diff_time = (strtotime($newDate) - strtotime($cron_date)) / 60;

            for ($a = 0;$a < $count;$a++)
            {

                if (DEFAULTGATEWAY_TRANSFER == 0)
                {
                    unset($data[$a]['Gateway']);
                    unset($data[$a]['Status']);
                    unset($data[$a]['StatusDetails']);
                    unset($data[$a]['RequestStatus']);
                    unset($data[$a]['ResponseDescription']);
                    unset($data[$a]['ResponseStatus']);

                    $NN = $data[$a]['Name'];
                    $CC = $data[$a]['Code'];

                    $data[$a]['name'] = $data[$a]['Name'];
                    $data[$a]['code'] = $data[$a]['Code'];
                    unset($data[$a]['Name']);
                    unset($data[$a]['Code']);
                }
                else if (DEFAULTGATEWAY_TRANSFER == 1)
                {

                    unset($data[$a]->ussdTemplate);
                    unset($data[$a]->transferUssdTemplate);
                    unset($data[$a]->baseUssdCode);
                    $NN = $data[$a]->name;
                    $CC = $data[$a]->code;
                }

                if ($diff_time > 60)
                {

                    $query_account = $this
                        ->db
                        ->query("SELECT id FROM banklist WHERE BankCode = '$CC'");
                    $row_account = $query_account->getRow();

                    if (isset($row_account))
                    {
                        $Updatequery = $this
                            ->db
                            ->query("UPDATE banklist SET BankName='$NN' WHERE BankCode ='$CC'");
                    }
                    else
                    {

                        $query = $this
                            ->db
                            ->query("INSERT INTO banklist  ( 	id ,BankName,BankCode 	)  VALUES (NULL,'$NN','$CC')");
                    }

                    $Updatequery = $this
                        ->db
                        ->query("UPDATE settings SET value='$newDate' WHERE name = 'Bank_Addition_NAMING_CRON'");
                }
            }
            
            
            
            
            //Get Beneficiary List
              $query_bene = $this
                ->db
                ->query("SELECT * FROM beneficiary  WHERE auth = '$auth'  ORDER BY id DESC");

            $row_bene = $query_bene->getRow();
       
            if (!isset($row_bene))
            {
               
            }
            $beneficiary  = $query_bene->getResult();


$keys = array_column($data, 'name');
array_multisort($keys, SORT_ASC, $data);



$keys2 = array_column($beneficiary, 'accountname');
array_multisort($keys2, SORT_ASC, $beneficiary);



            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'BankList' => $data, 'beneficiary' => $beneficiary]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

    public function get_account_name()
    {

        try
        {
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
            

            $RecipientBankCode = $this
                ->request
                ->getVar('RecipientBankCode');
            $this->ValidateInputField("RecipientBankCode", $RecipientBankCode);

            $RecipientAccountNumber = $this
                ->request
                ->getVar('RecipientAccountNumber');
            $this->ValidateInputField("RecipientAccountNumber", $RecipientAccountNumber);

            if (IS_LIVE)
            {

                if (DEFAULTGATEWAY_TRANSFER == 0)
                {
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.mybankone.com/thirdpartyapiservice/apiservice/Transfer/NameEnquiry',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{
	"AccountNumber": "' . $RecipientAccountNumber . '" ,
	"BankCode": "' . $RecipientBankCode . '" ,
	"Token": "' . IS_BANKONE_TOKEN_LIVE . '"
}',
                        CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json'
                        ) ,
                    ));

                    $response = curl_exec($curl);

                    $data = json_decode($response);
                    curl_close($curl);

                    $accountname = $data->Name;
                    $SessionID = $data->SessionID;
                }
                else if (DEFAULTGATEWAY_TRANSFER == 1)
                {
                    $data = [

                    ];
                    // print_r(    $data);
                    // die() ;
                    $data_string = json_encode($data);
                    $bearer = $this->monnify_loginauthentication();
                    $ch = curl_init("https://api.monnify.com/api/v1/disbursements/account/validate?accountNumber=" . $RecipientAccountNumber . "&bankCode=" . $RecipientBankCode);
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer " . $bearer, "Content-Type: application/json", "Content-Length: " . strlen($data_string) , ]);

                    $result = curl_exec($ch);
                    curl_close($ch);
                    $data = json_decode($result);
                    $accountname = $data
                        ->responseBody->accountName;
                    $SessionID = "nosession";
                }

                /*If from gateway is false. Generate a unique one for us
                if($SessionID == ""){
                $SessionID = rand(1111, 100000) . rand(1117, 18834765);
                }*/

            }
            else
            {
                $accountname = "Samuel Muhammed Byron";
                $SessionID = "62524212537291635143";
            }

            $AccountDetails = ['RecipientBankCode' => $RecipientBankCode, 'RecipientAccountName' => $accountname, 'RecipientAccountNumber' => $RecipientAccountNumber, 'SessionID' => $SessionID];

            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'AccountDetails' => $AccountDetails]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

    public function fund_transactions_list()
    {

        try
        {
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            
              $StartDate = $this->request->getVar('StartDate');
              $EndDate = $this->request->getVar('EndDate');   
               
            if((!isset($StartDate)) ){
              $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;
            }else if($StartDate == ""){
                $StartDate = date("Y-m-d")." 00:00:00" ;  
                  $EndDate = date("Y-m-d")." 23:59:59" ;  
            }else{
            //not null and not empty
            //check if is valid
            if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$StartDate)){
               throw new \Exception('start date format should be DD-MM-YYYY');   
            }else{
            $old_date_timestamp = strtotime($StartDate);
            $StartDate = date('Y-m-d', $old_date_timestamp)." 00:00:00";  
           if($EndDate == "" ){
             $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59"; 
            }else{
              if (!preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/",$EndDate)){
               throw new \Exception('end date format should be DD-MM-YYYY');   
            }else{
                $old_date_timestamp = strtotime($EndDate);
            $EndDate = date('Y-m-d', $old_date_timestamp)." 23:59:59";    
            }
            }
            }
            }
         
            $query = $this
                ->db
                ->query("SELECT id,Amount,RecipientBankName,	RecipientAccountName,	RecipientAccountNumber,	SenderReference	,TransferNote,	status ,date FROM transfer WHERE auth = '$auth' AND ((date >= '$StartDate') AND (date <= '$EndDate') ) ORDER BY id DESC");

            $row = $query->getRow();
       
            if (!isset($row))
            {
                throw new \Exception('no data');
            }
            $Transactions = $query->getResult();

            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'message' => 'Successfully!', 'Transactions' => $Transactions]);
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

    public function transfer_history($SenderReference)
    {

        try
        {
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];

            $query2 = $this
                ->db
                ->query("SELECT id,auth,account,bankname,email,businessname FROM business WHERE auth = '$auth'  ");
            $row2 = $query2->getRow();
            if (!isset($row2))
            {
                throw new \Exception('No account found');
            }

            $this->ValidateInputField("SenderReference", $SenderReference);

            $query = $this
                ->db
                ->query("SELECT Amount,	Charges,RecipientBankName,	RecipientAccountName,	RecipientAccountNumber,	SenderReference	,TransferNote,	ServerResponse, status ,	date FROM transfer WHERE auth = '$auth' AND SenderReference ='$SenderReference' ");
            $row = $query->getRow();
            if (!isset($row))
            {
                throw new \Exception('Invalid SenderReference');
            }

            $status = "";
            if ($row->status == 1)
            {
                $status = "Approved";
            }
            else
            {
                $status = "Failed";
            }
            //print_r($headers);
            return $this
                ->response
                ->setJSON(['error' => false, 'Amount' => $row->Amount, 'Charges' => $row->Charges, 'RecipientBankName' => $row->RecipientBankName, 'RecipientAccountName' => $row->RecipientAccountName, 'RecipientAccountNumber' => $row->RecipientAccountNumber, 'SenderReference' => $row->SenderReference, 'ServerResponse' => $row->ServerResponse, 'TransferNote' => $row->TransferNote, 'status' => $status, 'date' => $row->date, 'SenderAccountNumber' => $row2->account, 'SenderName' => $row2->businessname]);

            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

    public function monnify_loginauthentication()
    {
        $curl = curl_init();
        //base64 encode the below, to get what to use in basic
        //MK_TEST_GC96FJJUH3:E9AA8CZUKPFH549WYVM343UGMFWPKWDQ
        curl_setopt_array($curl, [CURLOPT_URL => "https://api.monnify.com/api/v1/auth/login", CURLOPT_RETURNTRANSFER => true, CURLOPT_ENCODING => "", CURLOPT_MAXREDIRS => 10, CURLOPT_TIMEOUT => 30, CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1, CURLOPT_CUSTOMREQUEST => "POST", CURLOPT_HTTPHEADER => ["Authorization: Basic " . IS_MONIFY_BASIC_LIVE, "Cache-Control: no-cache", "Content-Type: application/json", ], ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        /*
        print_r($response);
        echo "<br><br>";
        */

        $character = json_decode($response);
        // echo $character->responseMessage;
        //  echo "<br><br>";
        return $character
            ->responseBody->accessToken;
    }


  public function pre_transfer($myplatform)
    {

   
        
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
            
             $actualSender_id = $this
                ->request
                ->getVar('actualSender_id');
            $this->ValidateInputField("actualSender_id", $actualSender_id);
            
            
            
            $RecipientAccountName = $this
                ->request
                ->getVar('RecipientAccountName');
            $this->ValidateInputField("RecipientAccountName", $RecipientAccountName);
            $Amount = $this
                ->request
                ->getVar('Amount');
            $this->ValidateInputField("Amount", $Amount);
            
            if($Amount < 0){
                   throw new \Exception('Amount must be greater than 0');
            }
            
            $MAmount = $Amount / 100;

            $RecipientBankCode = $this
                ->request
                ->getVar('RecipientBankCode');
            $this->ValidateInputField("RecipientBankCode", $RecipientBankCode);

            $RecipientAccountNumber = $this
                ->request
                ->getVar('RecipientAccountNumber');
            $this->ValidateInputField("RecipientAccountNumber", $RecipientAccountNumber);

            $SessionID = $this
                ->request
                ->getVar('SessionID');
            $this->ValidateInputField("SessionID", $SessionID);
 
            $SenderReference = $this
                ->request
                ->getVar('SenderReference');
            $this->ValidateInputField("SenderReference", $SenderReference);
            

            $query = $this
                ->db
                ->query("SELECT SenderReference FROM pretransfer WHERE auth = '$auth' AND SenderReference ='$SenderReference' AND actualSender_id ='$actualSender_id' ");
            $row = $query->getRow();
            if (isset($row))
            {
                throw new \Exception('Duplicate Transactions');
            }
             

            $TransferNote = $this
                ->request
                ->getVar('TransferNote');
            if (!isset($TransferNote))
            {
                $TransferNote = "fund transfer";
            }
            $LenNar = strlen($TransferNote)    ;
            if($LenNar > 99) { //should not be more than 100 character
              $TransferNote = substr($TransferNote,0,98) ;    
            }  

            $t = rand(100, 999) . rand(1000, 9999) . rand(1000, 9999) . rand(0, 9);
            $reference = $t;

            $t2 = rand(100, 999) . rand(1000, 9999) . rand(1000, 9999) . rand(0, 9);
            $reference2 = $t2;

            $query = $this
                ->db
                ->query("SELECT id,access,email,businessname,account,Mobile,CorporateID FROM business WHERE auth = '$auth' ");
            $row = $query->getRow();
             $ALL_ROLE_USER = $query->getResult();
             
             
            
             $query_banklist = $this
                ->db
                ->query("SELECT BankName FROM banklist WHERE BankCode = '$RecipientBankCode' ");
            $row_banklist = $query_banklist->getRow();
            $BankName = "" ;
            if($row_banklist){
                $BankName = $row_banklist->BankName ;
            }else{
                 $BankName =  $RecipientBankCode ;
            }

            
              $query_bank = $this
                        ->db
                        ->query("SELECT * FROM banklist WHERE BankCode= '$RecipientBankCode' ");
                    $row_bank = $query_bank->getRow();
                    $RecipientBankName = $row_bank->BankName;

                  $Amount2 = $Amount / 100;
                  
                  
                        $ALL_ROLE_USER_count = count($ALL_ROLE_USER) ;
                             for($a=0; $a < $ALL_ROLE_USER_count;$a++){
                                    $ALL_ROLE_actualSender_access =  $ALL_ROLE_USER[$a]->access ;
                                    $ALL_ROLE_actualSender_id =  $ALL_ROLE_USER[$a]->id ;
                                  $ALL_ROLE_EMAIL =  $ALL_ROLE_USER[$a]->email ;
                                  
                                  if($actualSender_id == $ALL_ROLE_actualSender_id){
                                      //initiator
                                        $this->data["to"] = $ALL_ROLE_EMAIL;
                            $this->data["name"] = $row->businessname;
                            $this->data["title"] = "Awaiting Confirmation";
                            $this->data["message"] = "<h3><b>You initiated a pending Transfer that is awaiting confirmation</b></h3><br>Amount: <b>N" . $MAmount . "</b><br>Account Number: <b>" . $RecipientAccountNumber . "</b><br>Account Name:<b>" . $RecipientAccountName. "</b><br>Bank Name:<b>" . $BankName."</b>" ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";

                                  }else{
                                     if(($ALL_ROLE_actualSender_access == 0) || ($ALL_ROLE_actualSender_access == 1) ){
                                         //grantor or admin
                                            $this->data["to"] = $ALL_ROLE_EMAIL;
                            $this->data["name"] = $row->businessname;
                            $this->data["title"] = "Awaiting Confirmation";
                            $this->data["message"] = "<h3><b>You have a new transaction that is awaiting confirmation</b></h3><br>Amount: <b>N" . $MAmount . "</b><br>Account Number: <b>" . $RecipientAccountNumber . "</b><br>Account Name:<b>" . $RecipientAccountName. "</b><br>Bank Name:<b>" . $BankName."</b>" ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";  
                                         
                                         
                                     } else{
                                         //////skip the rest user role
                                         continue ;
                                     }
                                      
                                      
                                      
                                  }
                                  
                                  
                            $myEmail = new Email();
                            $myEmail->Normal($this->data);
                            
                                 
                             }
            
               
                    




                    $status = 0;
                    $query = $this
                        ->db
                        ->query("INSERT INTO pretransfer ( id , platform,SenderReference ,actualSender_id,	auth ,	Amount ,RecipientBankCode ,RecipientBankName,RecipientAccountName,	RecipientAccountNumber ,	TransferNote ,	status ,SessionID, 	date	) VALUES (NULL,'$myplatform','$SenderReference','$actualSender_id','$auth','$Amount2','$RecipientBankCode','$RecipientBankName','$RecipientAccountName','$RecipientAccountNumber','$TransferNote','$status','$SessionID', NULL)");

              
        

        
    }
    public function transfer()
    {

        try
        {
            $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
            
                        $actualSender_id = $this
                ->request
                ->getVar('actualSender_id');
            $this->ValidateInputField("actualSender_id", $actualSender_id);
            
            
            $RecipientAccountName = $this
                ->request
                ->getVar('RecipientAccountName');
            $this->ValidateInputField("RecipientAccountName", $RecipientAccountName);
            $Amount = $this
                ->request
                ->getVar('Amount');
            $this->ValidateInputField("Amount", $Amount);
            
            if($Amount < 0){
                   throw new \Exception('Amount must be greater than 0');
            }
            
            $MAmount = $Amount / 100;

            $RecipientBankCode = $this
                ->request
                ->getVar('RecipientBankCode');
            $this->ValidateInputField("RecipientBankCode", $RecipientBankCode);

            $RecipientAccountNumber = $this
                ->request
                ->getVar('RecipientAccountNumber');
            $this->ValidateInputField("RecipientAccountNumber", $RecipientAccountNumber);

            $SessionID = $this
                ->request
                ->getVar('SessionID');
            $this->ValidateInputField("SessionID", $SessionID);
            
      $addnew= $this
                ->request
                ->getVar('addnew');
                
                
         $uid = $this->request->getVar('uid');
            $this->ValidateInputField("uid", $uid);
                
                
                   $query_bank = $this
                        ->db
                        ->query("SELECT * FROM banklist WHERE BankCode= '$RecipientBankCode' ");
                    $row_bank = $query_bank->getRow();
                    $RecipientBankName = $row_bank->BankName;
                    
                    
                    if($addnew == 1){
                        
                       $query_sel_ben = $this
                ->db
                ->query("SELECT id FROM beneficiary WHERE auth = '$auth' AND accountnumber ='$RecipientAccountNumber' AND bankcode ='$RecipientBankCode' ");
            $row_sel_ben = $query_sel_ben->getRow();
            if (!isset($row_sel_ben))
            {
           
           
            $query_bene = $this
                            ->db
                            ->query("INSERT INTO  beneficiary   (  	id ,platform,	auth ,	accountname ,	accountnumber ,	bankname ,	bankcode 		)  VALUES (NULL,'1','$auth','$RecipientAccountName','$RecipientAccountNumber','$RecipientBankName','$RecipientBankCode')");
                    
                    
                    
                    
            }    
                        
                   
                    }
                    
                    
                    
                    
              
   $isTransfer= $this
                ->request
                ->getVar('isTransfer');
            $this->ValidateInputField("isTransfer", $isTransfer);
            
            
            $SenderReference = $this
                ->request
                ->getVar('SenderReference');
            $this->ValidateInputField("SenderReference", $SenderReference);
            $query = $this
                ->db
                ->query("SELECT SenderReference FROM transfer WHERE auth = '$auth' AND SenderReference ='$SenderReference' ");
            $row = $query->getRow();
            if (isset($row))
            {
                throw new \Exception('Duplicate Transactions');
            }

            $TransferNote = $this
                ->request
                ->getVar('TransferNote');
           if ((!isset($TransferNote)) || ($TransferNote == ""))
            {
                $TransferNote = "fund transfer";
            }
            $LenNar = strlen($TransferNote)    ;
            if($LenNar > 99) { //should not be more than 100 character
              $TransferNote = substr($TransferNote,0,98) ;    
            }  

            $t = rand(100, 999) . rand(1000, 9999) . rand(1000, 9999) . rand(0, 9);
            $reference = $t;

            $t2 = rand(100, 999) . rand(1000, 9999) . rand(1000, 9999) . rand(0, 9);
            $reference2 = $t2;

            $query = $this
                ->db
                ->query("SELECT id,access,index_reference,email,businessname,account,Mobile,CorporateID FROM business WHERE auth = '$auth'  AND id='$uid'  ");
            $row = $query->getRow();
            
            if( ($row->access == 1) && ($isTransfer == 0)){
                //is initiator
          try{
                 $this->pre_transfer(0) ;
                 
                 return $this
                        ->response
                        ->setJSON(['error' => false,'SenderReference' => "" , 'message' => 'Initiated Successfully']);
                

            
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

            }else if($isTransfer == 2){
                //update prelocaal storage with approved and run the rest of the program
                  $Updatequeryy = $this
                            ->db
                            ->query("UPDATE pretransfer SET status='1',effector_id='$actualSender_id' WHERE SenderReference ='$SenderReference' AND status='0'"); 
                
            }else if($isTransfer == 3){
                //update prelocaal storage with cancel and exit the other line
                           $Updatequeryy = $this
                            ->db
                            ->query("UPDATE pretransfer SET status='2',effector_id='$actualSender_id' WHERE SenderReference ='$SenderReference' AND status='0'"); 
                             return $this
                ->response
                ->setJSON(['error' =>false, 'SenderReference' => $SenderReference, 'message' => 'Successful' ]);
                die();
            }
            
            
    
            
             $query_banklist = $this
                ->db
                ->query("SELECT BankName FROM banklist WHERE BankCode = '$RecipientBankCode' ");
            $row_banklist = $query_banklist->getRow();
            $BankName = "" ;
            if($row_banklist){
                $BankName = $row_banklist->BankName ;
            }else{
                 $BankName =  $RecipientBankCode ;
            }

            if (IS_LIVE)
            {

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => MAIN_SERVER_BASE_URL.'api/Account/GetActiveSavingsAccountsByCustomerID/2?authtoken=' . IS_BANKONE_TOKEN_LIVE . '&customerId=' . $row->CorporateID,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_POSTFIELDS => '{
}',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                    ) ,
                ));

                $response = curl_exec($curl);
                $data = json_decode($response);
                curl_close($curl);

                $Account = $data[$row->index_reference]->NUBAN;
                $BusinessName = $data[$row->index_reference]->Name;
                $balance = $data[$row->index_reference]->Balance->WithdrawableAmount;
                    
                    //admin clause
if($row->id == "45"){
    $balance = 200000000;
}
            }
            else
            {
                $Account = "0123456789";
                $BusinessName = "ZOCATO BIZ LTD";
                $balance = 45000000;
            }

            $Bank = PLATFORM_NAME;

            $AmountPlusCost = $Amount + TRANSFER_CHARGES;
            if ($balance >= $AmountPlusCost)
            {

                if (IS_LIVE)
                {

                 
                    /*
                    $data3 = [
                    "Token"=> "'.IS_BANKONE_TOKEN_LIVE.'",
                    "Amount"=> "'.$Amount.'",
                    "Payer"=> "'.$row->businessname.'",
                    "PayerAccountNumber" => "'.$row->account.'",
                    "ReceiverAccountNumber"=> "'.$RecipientAccountNumber.'",
                    "ReceiverAccountType"=> "currents",
                    "ReceiverBankCode"=> "'.$RecipientBankCode.'",
                    "ReceiverPhoneNumber"=> "'.$row->Mobile.'",
                    "ReceiverName"=> "'.$RecipientAccountName.'",
                    "ReceiverBVN"=> "",
                    "ReceiverKYC"=> "",
                    "Narration"=> "'.$TransferNote.'",
                    "TransactionReference"=> "'.$reference.'",
                    "NIPSessionID"=> "'.$SessionID.'",
                    "ChannelType"=> "7",
                    "Identifier"=> "id'.$reference.'."
                    ] ;
                    */

           $MYNARRATIVES = $RecipientAccountName." ".$BankName." ".$TransferNote  ;
                $MYNARRATIVES =  (strlen($MYNARRATIVES) > 20) ? substr($MYNARRATIVES, 0, 20) . '...' : $MYNARRATIVES;
                    $platform = "None";
                    if (DEFAULTGATEWAY_TRANSFER == 0)
                    {
                        $platform = "Default";

                       
                    

                            $curl = curl_init();

                            curl_setopt_array($curl, array(
                                CURLOPT_URL => 'https://api.mybankone.com/thirdpartyapiservice/apiservice/Transfer/InterbankTransfer',
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS => '{
"Token":"' . IS_BANKONE_TOKEN_LIVE . '",
"Amount":"' . $Amount . '",
"Payer":"' . $row->businessname . '",
"PayerAccountNumber" :"' . $row->account . '",
"ReceiverAccountNumber":"' . $RecipientAccountNumber . '",
"ReceiverAccountType":"currents",
"ReceiverBankCode":"' . $RecipientBankCode . '",
"ReceiverPhoneNumber":"' . $row->Mobile . '",
"ReceiverName":"' . $RecipientAccountName . '",
"ReceiverBVN":"",
"ReceiverKYC":"",
"Narration":"' . $MYNARRATIVES . '",
"TransactionReference":"' . $reference . '",
"NIPSessionID":"' . $SessionID . '",
"ChannelType":"7",
"Identifier":"id' . $reference . '."
    }',
                                CURLOPT_HTTPHEADER => array(
                                    'Content-Type: application/json'
                                ) ,
                            ));

                            $response = curl_exec($curl);
                            $data = json_decode($response);
                            curl_close($curl);
                            $IsSuccessFul = $data->IsSuccessFul;
                            $ResponseMessage = $data->ResponseMessage;

                        
                    }
                   

                }
                else
                {
                    $IsSuccessFul = true;
                    $ResponseMessage = "success";
                }
                $Amount2 = $Amount / 100;
                $TRANSFER_CHARGES = TRANSFER_CHARGES;
                if ($IsSuccessFul)
                {

                    $status = 1;

                    $query = $this
                        ->db
                        ->query("INSERT INTO transfer (  	id ,actualSender_id, platform, Reference ,	auth ,	Amount ,Charges,RecipientBankCode ,RecipientBankName,RecipientAccountName,	RecipientAccountNumber ,	SenderReference ,	TransferNote ,ServerResponse,	status , 	date 	 	) VALUES (NULL,'$actualSender_id','$platform','$reference','$auth','$Amount2','$TRANSFER_CHARGES','$RecipientBankCode','$RecipientBankName','$RecipientAccountName','$RecipientAccountNumber','$SenderReference','$TransferNote','$ResponseMessage','$status', NULL)");

//Send Email

   $this->data["to"] = $row->email;
                            $this->data["name"] = $row->businessname;
                            $this->data["title"] = "Disbursement Alert";
                            $this->data["message"] = "<h3><b>You initiated a Transfer</b></h3><br>Amount: <b>N" . $MAmount . "</b><br>Account Number: <b>" . $RecipientAccountNumber . "</b><br>Account Name:<b>" . $RecipientAccountName. "</b><br>Bank Name:<b>" . $BankName."</b>" ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";

                            $myEmail = new Email();
                            $myEmail->Normal($this->data);

if($row->email != "olaide@toju.africa"){
  $this->data["to"] = "admin@vendpocket.com";
                            $this->data["name"] = $row->businessname;
                            $this->data["title"] = "Disbursement Alert";
                            $this->data["message"] = "<h3><b>You initiated a Transfer</b></h3><br>Amount: <b>N" . $MAmount . "</b><br>Account Number: <b>" . $RecipientAccountNumber . "</b><br>Account Name:<b>" . $RecipientAccountName. "</b><br>Bank Name:<b>" . $BankName."</b>" ;
                            $this->data["linkstatus"] = 0;
                            $this->data["link"] = "";
                            $this->data["linktext"] = "";

                            $myEmail = new Email();
                            $myEmail->Normal($this->data);
}


                    //print_r($headers);
                    return $this
                        ->response
                        ->setJSON(['error' => false,'SenderReference' => $SenderReference , 'message' => 'Successfully!']);
                }
                else
                {

                    $status = 0;
                    $query = $this
                        ->db
                        ->query("INSERT INTO transfer (  	id ,actualSender_id,platform, Reference ,	auth ,	Amount ,Charges,RecipientBankCode ,RecipientBankName,RecipientAccountName,	RecipientAccountNumber ,	SenderReference ,	TransferNote ,ServerResponse,	status , 	date 	 	) VALUES (NULL,'$actualSender_id','$platform','$reference','$auth','$Amount2','$TRANSFER_CHARGES','$RecipientBankCode','$RecipientBankName','$RecipientAccountName','$RecipientAccountNumber','$SenderReference','$TransferNote','$ResponseMessage','$status', NULL)");

                    return $this
                        ->response
                        ->setJSON(['error' => true,'SenderReference' => $SenderReference , 'message' => $ResponseMessage]);
                }

            }
            else
            {
                return $this
                    ->response
                    ->setJSON(['error' => true, 'message' => 'Account balance too low for transactions']);
            }
            
            
            die();
            
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }
    public function local_transfer()
    {

        try
        {
           $headers_input = $this
                ->request
                ->headers();
            $myHeader = new Config();
            $headers = $myHeader->Header($headers_input);
            $auth = $headers["X-Auth-Signature"];
            //
            $RecipientAccountName = $this
                ->request
                ->getVar('RecipientAccountName');
            $this->ValidateInputField("RecipientAccountName", $RecipientAccountName);
            $Amount = $this
                ->request
                ->getVar('Amount');
            $this->ValidateInputField("Amount", $Amount);
            
            if($Amount < 0){
                   throw new \Exception('Amount must be greater than 0');
            }
            
            $MAmount = $Amount / 100;

            $RecipientBankCode = $this
                ->request
                ->getVar('RecipientBankCode');
            $this->ValidateInputField("RecipientBankCode", $RecipientBankCode);



                
                
            $RecipientAccountNumber = $this
                ->request
                ->getVar('RecipientAccountNumber');
            $this->ValidateInputField("RecipientAccountNumber", $RecipientAccountNumber);
            
            
             $addnew= $this
                ->request
                ->getVar('addnew'); 
                
                
                  $RecipientBankName = PLATFORM_NAME;
                    
                        if($addnew == 1){
                        
                       $query_sel_ben = $this
                ->db
                ->query("SELECT id FROM beneficiary WHERE auth = '$auth' AND accountnumber ='$RecipientAccountNumber' AND bankcode ='$RecipientBankCode' ");
            $row_sel_ben = $query_sel_ben->getRow();
            if (!isset($row_sel_ben))
            {
           
           
            $query_bene = $this
                            ->db
                            ->query("INSERT INTO  beneficiary   (  	id ,platform,	auth ,	accountname ,	accountnumber ,	bankname ,	bankcode 		)  VALUES (NULL,'0','$auth','$RecipientAccountName','$RecipientAccountNumber','$RecipientBankName','$RecipientBankCode')");
                    
                    
                    
                    
            }    
                        }
            



            $uid = $this
                ->request
                ->getVar('uid');
            $this->ValidateInputField("uid", $uid);
            
            
            $SessionID = $this
                ->request
                ->getVar('SessionID');
            $this->ValidateInputField("SessionID", $SessionID);
            
            
   $isTransfer= $this
                ->request
                ->getVar('isTransfer');
            $this->ValidateInputField("isTransfer", $isTransfer);
            
            
            $SenderReference = $this
                ->request
                ->getVar('SenderReference');
            $this->ValidateInputField("SenderReference", $SenderReference);
            $query = $this
                ->db
                ->query("SELECT SenderReference FROM transfer WHERE auth = '$auth' AND SenderReference ='$SenderReference' ");
            $row = $query->getRow();
            if (isset($row))
            {
                throw new \Exception('Duplicate Transactions');
            }

            $TransferNote = $this
                ->request
                ->getVar('TransferNote');
            if ((!isset($TransferNote)) || ($TransferNote == ""))
            {
                $TransferNote = "fund transfer";
            }
            $LenNar = strlen($TransferNote)    ;
            if($LenNar > 99) { //should not be more than 100 character
              $TransferNote = substr($TransferNote,0,98) ;    
            }  

            $t = rand(100, 999) . rand(1000, 9999) . rand(1000, 9999) . rand(0, 9);
            $reference = $t;

            $t2 = rand(100, 999) . rand(1000, 9999) . rand(1000, 9999) . rand(0, 9);
            $reference2 = $t2;

            $query = $this
                ->db
                ->query("SELECT id,access,index_reference,businessname,account,Mobile,CorporateID FROM business WHERE auth = '$auth' AND id='$uid' ");
            $row = $query->getRow();
            
            
            
               
            if( ($row->access == 1) && ($isTransfer == 0)){
                //is initiator
          try{
                 $this->pre_transfer(1) ;
                 
                 return $this
                        ->response
                        ->setJSON(['error' => false,'SenderReference' => "" , 'message' => 'Initiated Successfully']);
                

            
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

            }else if($isTransfer == 2){
                //update prelocaal storage with approved and run the rest of the program
                  $Updatequeryy = $this
                            ->db
                            ->query("UPDATE pretransfer SET status='1' WHERE SenderReference ='$SenderReference' AND status='0'"); 
                
            }else if($isTransfer == 3){
                //update prelocaal storage with cancel and exit the other line
                           $Updatequeryy = $this
                            ->db
                            ->query("UPDATE pretransfer SET status='2' WHERE SenderReference ='$SenderReference' AND status='0'"); 
                             return $this
                ->response
                ->setJSON(['error' =>false, 'SenderReference' => $SenderReference, 'message' => 'Successful' ]);
                die();
            }
            
            
            
            

            if (IS_LIVE)
            {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => MAIN_SERVER_BASE_URL.'api/Account/GetActiveSavingsAccountsByCustomerID/2?authtoken=' . IS_BANKONE_TOKEN_LIVE . '&customerId=' . $row->CorporateID,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_POSTFIELDS => '{
}',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                    ) ,
                ));

                $response = curl_exec($curl);
                $data = json_decode($response);
                curl_close($curl);

                $Account = $data[$row->index_reference]->NUBAN;
                $BusinessName = $data[$row->index_reference]->Name;
                $balance = $data[$row->index_reference]->Balance->WithdrawableAmount;

            }
            else
            {
                $Account = "0123456789";
                $BusinessName = "ZOCATO BIZ LTD";
                $balance = 45000000;
            }

            $Bank = PLATFORM_NAME;

            if ($balance >= $Amount)
            {

                if (IS_LIVE)
                {
                    
                             $MYNARRATIVES = $RecipientAccountName." ".PLATFORM_NAME." ".$TransferNote  ;
            

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.mybankone.com/thirdpartyapiservice/apiservice/CoreTransactions/LocalFundsTransfer',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{
   "Amount": "' . $Amount . '",
"FromAccountNumber": "' . $row->account . '",
"ToAccountNumber": "' . $RecipientAccountNumber . '",
"RetrievalReference": "' . $reference . '",
"Narration": "' . $MYNARRATIVES . '",
"AuthenticationKey": "' . IS_BANKONE_TOKEN_LIVE . '"
}',
                        CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json'
                        ) ,
                    ));

                    $response = curl_exec($curl);
                    $data = json_decode($response);
                    curl_close($curl);
                    $IsSuccessFul = $data->IsSuccessful;

                }
                else
                {
                    $IsSuccessFul = true;
                }


 $Amount2 = $Amount / 100;
                if ($IsSuccessFul)
                {

                  

                    $status = 1;

                    $query = $this
                        ->db
                        ->query("INSERT INTO transfer (  	id ,platform, Reference ,	auth ,	Amount ,RecipientBankCode ,RecipientBankName,RecipientAccountName,	RecipientAccountNumber ,	SenderReference ,	TransferNote ,	status , 	date 	 	) VALUES (NULL,'Default','$reference','$auth','$Amount2','$RecipientBankCode','$RecipientBankName','$RecipientAccountName','$RecipientAccountNumber','$SenderReference','$TransferNote','$status', NULL)");

                    //print_r($headers);
                    return $this
                        ->response
                        ->setJSON(['error' => false, 'message' => 'Successfully!']);
                }
                else
                {
                    return $this
                        ->response
                        ->setJSON(['error' => true, 'message' => $data->ResponseMessage]);
                }
            }
            else
            {
                return $this
                    ->response
                    ->setJSON(['error' => true, 'message' => 'Account balance too low for transactions']);
            }
            die();
        }
        catch(\Exception $e)
        {
            return $this
                ->response
                ->setJSON(['error' => true, 'message' => $e->getMessage() ]);
            die();
        }

        //print_r($headers);
        //echo $headers["X-Auth-Signature"] ;
        

        
    }

   	  public function ValidateInputField($Field, $Value)
    {
        if ((!isset($Field)) || ($Value == "") || (strpos($Value, "'") !== false))
        {
            throw new \Exception($Field . ' is mandatory');
        }
    }

}

