<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.

$routes->post('/basic', 'Home::basic');

//V1
//admin

$routes->post('/v1/corporatebanking/view_bill', 'v1\Corporatebanking::view_bill');




$routes->get('/v1/getcypher', 'v1\Password::getcypher');



//client
$routes->post('/v1/bank/transfer', 'v1\Bank::transfer');
$routes->post('/v1/bank/local_transfer', 'v1\Bank::local_transfer');
$routes->post('/v1/bank/transfer_list', 'v1\Bank::fund_transactions_list');
$routes->post('/v1/bank/get/account/name', 'v1\Bank::get_account_name');
$routes->post('/v1/bank/doubleconfirmstatus', 'v1\Bank::doubleconfirmstatus');
$routes->post('/v1/bank/banklist', 'v1\Bank::bank_list');
$routes->post('/v1/initialisation/init', 'v1\Initialisation::init');
$routes->post('/v1/initialisation/init_multiple', 'v1\Initialisation::init_multiple');
$routes->post('/v1/corporatebanking/new', 'v1\Corporatebanking::newaccount');
$routes->post('/v1/corporatebanking/transaction_otp', 'v1\Corporatebanking::transaction_otp');
$routes->post('/v1/corporatebanking/two_2fa', 'v1\Corporatebanking::TWO_2FA');
$routes->post('/v1/corporatebanking/role_list', 'v1\Corporatebanking::role_list');
$routes->post('/v1/corporatebanking/forgot_pass', 'v1\Corporatebanking::forgot_password');
$routes->post('/v1/corporatebanking/forgot_pin', 'v1\Corporatebanking::forgot_pin');
$routes->post('/v1/corporatebanking/update_profile', 'v1\Corporatebanking::update_profile');
$routes->post('/v1/initialisation/account_stats', 'v1\Initialisation::account_stats');
$routes->post('/v1/corporatebanking/reset_pass', 'v1\Corporatebanking::reset_password');
$routes->post('/v1/corporatebanking/reset_pin', 'v1\Corporatebanking::reset_pin');
$routes->post('/v1/corporatebanking/transaction_summary', 'v1\Corporatebanking::transaction_summary');
$routes->post('/v1/corporatebanking/transaction_statement', 'v1\Corporatebanking::transaction_statement');
$routes->post('/v1/corporatebanking/role_action', 'v1\Corporatebanking::role_action');
$routes->post('/v1/corporatebanking/beneficiary_action', 'v1\Corporatebanking::beneficiary_action');
$routes->post('/v1/corporatebanking/all_approval/(:any)', 'v1\Corporatebanking::all_approval/$1/');
$routes->post('/v1/corporatebanking/pending_approval', 'v1\Corporatebanking::pending_approval');
$routes->post('/v1/corporatebanking/alllog', 'v1\Corporatebanking::alllog');
$routes->post('/v1/corporatebanking/request_token', 'v1\Corporatebanking::request_token');


$routes->post('/v1/biller/get/cablebundle', 'v1\Biller::get_cablebundle');
$routes->post('/v1/biller/get/bundle', 'v1\Biller::get_bundle');
$routes->post('/v1/biller/purchase', 'v1\Biller::purchase');
$routes->post('/v1/biller/cablepurchase', 'v1\Biller::cablepurchase');
$routes->post('/v1/biller/transactions', 'v1\Biller::transactions');
$routes->get('/v1/bank/transaction/(:any)', 'v1\Bank::transfer_history/$1/');

$routes->post('/v1/corporatebanking/allcustomer', 'v1\Corporatebanking::allcustomer');

$routes->post('/v1/utility/getbvn', 'v1\Utility::bvn');

$routes->post('/v1/admin/single_business_application/(:any)', 'v1\Admin::single_business_application/$1/');
$routes->post('/v1/admin/single_customer_application/(:any)', 'v1\Admin::single_customer_application/$1/');

$routes->post('/v1/admin/cloud_cron', 'v1\Admin::cloud_cron');
$routes->post('/v1/admin/cloud_init', 'v1\Admin::cloud_init');
$routes->post('/v1/admin/all_transfer', 'v1\Admin::all_transfer');
$routes->post('/v1/admin/all_bill', 'v1\Admin::all_bill');
$routes->post('/v1/admin/all_business', 'v1\Admin::all_business');
$routes->post('/v1/admin/all_business_application', 'v1\Admin::all_business_application');
$routes->post('/v1/admin/all_customer_application', 'v1\Admin::all_customer_application');

$routes->post('/v1/application_otp', 'v1\Application::application_otp');
$routes->post('/v1/application_business/(:any)', 'v1\Application::application_business/$1/');

$routes->post('/v1/initialisation/confirmbusinessteam', 'v1\Initialisation::confirmbusinessteam');
$routes->post('/v1/initialisation/getnewbusinessteam/(:any)/(:any)', 'v1\Initialisation::getnewbusinessteam/$1/$2/');
$routes->post('/v1/initialisation/newbusinessactivate/(:any)', 'v1\Initialisation::newbusinessactivate/$1/');
$routes->post('/v1/initialisation/newbusinessaccount', 'v1\Initialisation::newbusinessaccount');
$routes->post('/v1/application_cron', 'v1\Application::application_cron');
$routes->post('/v1/application_submit', 'v1\Application::application_submit');
$routes->post('/v1/application_team/(:any)', 'v1\Application::application_team/$1/');
$routes->post('/v1/application_contact/(:any)', 'v1\Application::application_contact/$1/');
$routes->post('/v1/application_director/(:any)', 'v1\Application::application_director/$1/');
$routes->post('/v1/application_document', 'v1\Application::application_document');
$routes->post('/v1/admin/change_application_status/(:any)', 'v1\Admin::change_application_status/$1/');

$routes->post('/v1/personal/application_otp', 'v1\Personal::application_otp');
$routes->post('/v1/personal/application_personal/(:any)', 'v1\Personal::application_personal/$1/');
$routes->post('/v1/personal/application_contact/(:any)', 'v1\Personal::application_contact/$1/');
$routes->post('/v1/personal/application_director/(:any)', 'v1\Personal::application_director/$1/');
$routes->post('/v1/personal/application_document/(:any)', 'v1\Personal::application_document/$1/');
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
