<!doctype html>
<!-- paulirish.com/2008/conditional-stylesheets-vs-css-hacks-answer-neither/ -->
<!--[if lt IE 7]> <html class="no-js ie6 oldie" lang="en"> <![endif]-->
<!--[if IE 7]>    <html class="no-js ie7 oldie" lang="en"> <![endif]-->
<!--[if IE 8]>    <html class="no-js ie8 oldie" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="en"> <!--<![endif]-->
<head>
  <meta charset="utf-8">
  
  <!-- DNS prefetch -->
  <link rel=dns-prefetch href="//fonts.googleapis.com">

  <!-- Use the .htaccess and remove these lines to avoid edge case issues.
       More info: h5bp.com/b/378 -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

  <title>Login :: Management</title>
  <meta name="description" content="">
  <meta name="author" content="">

  <!-- Mobile viewport optimized: j.mp/bplateviewport -->
  <meta name="viewport" content="width=device-width,initial-scale=1">
     <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Place favicon.ico and apple-touch-icon.png in the root directory: mathiasbynens.be/notes/touch-icons -->
  <link rel="icon" type='image/x-icon' href="img/6.png"/>
  <!-- CSS: implied media=all -->
  <!-- CSS concatenated and minified via ant build script-->
  <link rel="stylesheet" href="css/style.css"> <!-- Generic style (Boilerplate) -->
  <link rel="stylesheet" href="css/960.fluid.css"> <!-- 960.gs Grid System -->
  <link rel="stylesheet" href="css/main.css?id=8"> <!-- Complete Layout and main styles -->
  <link rel="stylesheet" href="css/buttons.css"> <!-- Buttons, optional -->
  <link rel="stylesheet" href="css/lists.css"> <!-- Lists, optional -->
  <link rel="stylesheet" href="css/icons.css"> <!-- Icons, optional -->
  <link rel="stylesheet" href="css/notifications.css"> <!-- Notifications, optional -->
  <link rel="stylesheet" href="css/typography.css"> <!-- Typography -->
  <link rel="stylesheet" href="css/forms.css"> <!-- Forms, optional -->
  <link rel="stylesheet" href="css/tables.css"> <!-- Tables, optional -->
  <link rel="stylesheet" href="css/charts.css"> <!-- Charts, optional -->
  <link rel="stylesheet" href="css/jquery-ui-1.8.15.custom.css"> <!-- jQuery UI, optional -->
  <!-- end CSS-->

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
 

  <!-- Fonts -->
  <link href="//fonts.googleapis.com/css?family=PT+Sans" rel="stylesheet" type="text/css">
  <!-- end Fonts-->

  <!-- More ideas for your <head> here: h5bp.com/d/head-Tips -->

  <!-- All JavaScript at the bottom, except for Modernizr / Respond.
       Modernizr enables HTML5 elements & feature detects; Respond is a polyfill for min/max-width CSS3 Media Queries
       For optimal performance, use a custom Modernizr build: www.modernizr.com/download/ -->
  <script src="js/libs/modernizr-2.0.6.min.js"></script>
</head>

<body class="special-page">


  <!-- Preloader -->
    <div id="preloader">
        <div class="loader"></div>
    </div>



  <!-- Begin of #container -->
  <div id="container">
  	
  	<!-- Begin of LoginBox-section -->
    <section id="login-box">
        
        
    		    <div class="position-fixed top-0 end-0 p-3">
        <div id="myToast" class="toast bg-success text-white" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <strong class="me-auto">    <span id="toatitle"></span></strong>
                <small>Just now</small>
                <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">
              <span id="toamessage"></span>
            </div>
        </div>
    </div>
    
    
    	<div class="block-border">
    		<div class="block-header">
    			<h1>Weston-Charis MFB Administrator Console</h1>
    			
    		
    
    
    		</div>
    		<form id="login-form" class="block-content form" action="javascript:handleClick()" method="post">
    		    <br><br>
    			<p class="inline-small-label">
					<label for="username">Email</label>
					<input type="text" id="email" value="" class="required">
				</p>
				<p class="inline-small-label">
					<label for="password">Password</label>
					<input type="password" id="password" value="" class="required">
				</p>
    			<p>
					<label style="display:none;"><input type="checkbox" name="keep_logged" /> Auto-login in future.</label>
				</p>
				
				<div class="clear"></div>
				
				<!-- Begin of #block-actions -->
    			<div class="block-actions">
					<ul class="actions-left"  style="display:none;">
						<li><a class="button" name="recover_password" href="javascript:void(0);">Recover Password</a></li>
						<li class="divider-vertical"></li>
						<li><a class="button red" id="reset-login" href="javascript:void(0);">Cancel</a></li>
					</ul>
					<ul class="actions-right">
						<li><input type="submit" class="button" value="Login"></li>
					</ul>
				</div> <!--! end of #block-actions -->
    		</form>
    		
    		
    	</div>
    </section> <!--! end of #login-box -->
  </div> <!--! end of #container -->


  <!-- JavaScript at the bottom for fast page loading -->

  <!-- Grab Google CDN's jQuery, with a protocol relative URL; fall back to local if offline -->
  <script src="//ajax.googleapis.com/ajax/libs/jquery/1.6.2/jquery.min.js"></script>
  <script>window.jQuery || document.write('<script src="js/libs/jquery-1.6.2.min.js"><\/script>')</script>


  <!-- scripts concatenated and minified via ant build script-->
  <script defer src="js/plugins.js"></script> <!-- lightweight wrapper for consolelog, optional -->
  <script defer src="js/mylibs/jquery.notifications.js"></script> <!-- Notifications  -->
  <script defer src="js/mylibs/jquery.uniform.min.js"></script> <!-- Uniform (Look & Feel from forms) -->
  <script defer src="js/mylibs/jquery.validate.min.js"></script> <!-- Validation from forms -->
  <script defer src="js/mylibs/jquery.tipsy.js"></script> <!-- Tooltips -->
  <script defer src="js/common.js"></script> <!-- Generic functions -->
  <script defer src="js/script.js"></script> <!-- Generic scripts -->
  
  <script type="text/javascript">
     var PreCheckCounter = 0 ;
     var CheckCounter = 0 ;
	$().ready(function() {
   
		/*
		 * Validate the form when it is submitted
		 */
		var validatelogin = $("#login-form").validate({
			invalidHandler: function(form, validator) {
      			var errors = validator.numberOfInvalids();
      			if (errors) {
        			var message = errors == 1
			          ? 'You missed 1 field. It has been highlighted.'
			          : 'You missed ' + errors + ' fields. They have been highlighted.';
        			$('#login-form').removeAlertBoxes();
        			$('#login-form').alertBox(message, {type: 'error'});
        			
      			} else {
            
       			 	$('#login-form').removeAlertBoxes();
           
      			}
            
    		}
       
		});
		
		jQuery("#reset-login").click(function() {
			validatelogin.resetForm();
		});
				
	});



function timeout() {
    setTimeout(function () {
        // Do Something Here
        // Then recall the parent function to
        // create a recursive loop.
    if(PreCheckCounter == CheckCounter){
   
  setTimeout(function(){
     window.location = "dashboard.php";
    }, 1000);	 
  
    
    }else{
        timeout();
    }
    }, 3000);
}


  function handleClick(){
      
      
         let preloader = document.getElementById("preloader");
            let container = document.querySelector("#container");
            preloader.style.opacity = "1";
             preloader.style.display = "flex";
                container.style.display = "none";

      
      
    var email = $("#email").val().trim();
        var password = $("#password").val().trim();
            $.ajax({
                url:'https://qa.atomafrica.tech/WestonCharis/endpoint/proxy/v1/admin/cloud_init',
                contentType: 'application/json' ,
                dataType: 'json',
                type:'post',
                data: JSON.stringify( { "user": email, "password": password } ),
                success:function(response){
                  
                  console.log(response) ;
                    
                   // alert("error2"+response.error) ;
                    if(!response.error){
                        
                      
                   PreCheckCounter = 0 ;
		 var Data = JSON.stringify(response);  
		 var Data2 = JSON.parse(Data) ; 
		   

		 sessionStorage.setItem("sess_Bus", Data2["Authorisation"].org_name);
    sessionStorage.setItem("auth", Data2["Authorisation"].auth);
	sessionStorage.setItem("accesscode", Data2["Authorisation"].accesscode);


  sessionStorage.setItem("service_virtual_status",Data2["service_virtual"].status);
  sessionStorage.setItem("service_virtual_base",Data2["service_virtual"].service_virtual_base);
  sessionStorage.setItem("service_virtual_all_virtual",Data2["service_virtual"].service_virtual_all_virtual);
  sessionStorage.setItem("service_virtual_all_transfer",Data2["service_virtual"].service_virtual_all_transfer);
  sessionStorage.setItem("service_virtual_all_deposit",Data2["service_virtual"].service_virtual_all_deposit);
  sessionStorage.setItem("service_virtual_all_business",Data2["service_virtual"].service_virtual_all_business);
  sessionStorage.setItem("service_virtual_all_bill",Data2["service_virtual"].service_virtual_all_bill);
  sessionStorage.setItem("service_virtual_authEndPoint",Data2["service_virtual"].service_virtual_authEndPoint);
  sessionStorage.setItem("service_virtual_cronEndPoint",Data2["service_virtual"].service_virtual_cronEndPoint);
  sessionStorage.setItem("service_virtual_bvnAdmin",Data2["service_virtual"].service_virtual_bvnAdmin);
  sessionStorage.setItem("service_virtual_newEnrol",Data2["service_virtual"].service_virtual_newEnrol);

  
if(Data2["service_virtual"].status > 0){
  PreCheckCounter++ ;
  Callservice_virtual() ;
}

  sessionStorage.setItem("service_banking_status",Data2["service_banking"].status);
  sessionStorage.setItem("service_banking_base",Data2["service_banking"].service_banking_base);
  sessionStorage.setItem("service_banking_business_application",Data2["service_banking"].service_banking_business_application);
  sessionStorage.setItem("service_banking_all_transfer",Data2["service_banking"].service_banking_all_transfer);
  sessionStorage.setItem("service_banking_all_customer_application",Data2["service_banking"].service_banking_all_customer_application);
  sessionStorage.setItem("service_banking_all_business",Data2["service_banking"].service_banking_all_business);
  sessionStorage.setItem("service_banking_all_bill",Data2["service_banking"].service_banking_all_bill);
  sessionStorage.setItem("service_banking_authEndPoint",Data2["service_banking"].service_banking_authEndPoint);
  sessionStorage.setItem("service_banking_cronEndPoint",Data2["service_banking"].service_banking_cronEndPoint);
  sessionStorage.setItem("service_banking_bvnAdmin",Data2["service_banking"].service_banking_bvnAdmin);
  sessionStorage.setItem("service_banking_newEnrol",Data2["service_banking"].service_banking_newEnrol);
  sessionStorage.setItem("service_banking_single_business_application",Data2["service_banking"].service_banking_single_business_application);
  sessionStorage.setItem("service_banking_single_customer_application",Data2["service_banking"].service_banking_single_customer_application);
    sessionStorage.setItem("service_banking_confirm_status",Data2["service_banking"].service_banking_confirm_status);

if(Data2["service_banking"].status > 0){
  PreCheckCounter++ ;
  Callservice_banking() ;
}



      preloader.style.opacity = "0";
                      preloader.style.display = "none";
                container.style.display = "block";


                       document.getElementById("toamessage").textContent = "Login Successfully!";
                   document.getElementById("toatitle").textContent = "Loading........";
            let toastElement = document.getElementById('myToast');

// Change background to bg-danger
if (!(toastElement.classList.contains("bg-success"))) {
toastElement.classList.remove("bg-danger");
toastElement.classList.add("bg-success");
}

// Show the toast
let toast = new bootstrap.Toast(toastElement);
toast.show();





timeout() ;

   

                   
                    }else{
                        
      preloader.style.opacity = "0";
                      preloader.style.display = "none";
                container.style.display = "block";
                
                
                       document.getElementById("toamessage").textContent = "please check the login information!";
                   document.getElementById("toatitle").textContent = "Invalid";
            let toastElement = document.getElementById('myToast');

// Change background to bg-danger
if (toastElement.classList.contains("bg-success")) {
toastElement.classList.remove("bg-success");
toastElement.classList.add("bg-danger");
}

// Show the toast
let toast = new bootstrap.Toast(toastElement);
toast.show();
    
                    }
                    
                    
                 
                  //  $("#message").html(msg);
                }
            });
      

  }


  function Callservice_banking(){

let service_banking_base = sessionStorage.getItem("service_banking_base");
let service_banking_authEndPoint = sessionStorage.getItem("service_banking_authEndPoint");

var email = $("#email").val().trim();
    var password = $("#password").val().trim();
        $.ajax({
            url:service_banking_base+service_banking_authEndPoint,
            contentType: 'application/json' ,
            dataType: 'json',
            type:'post',
            data: JSON.stringify( { "Rehoboth_Api_Email": email, "Rehoboth_Api_Password": password } ),
            success:function(response){
              
              console.log(response) ;
           
             
               // alert("error2"+response.error) ;
                if(!response.error){
                  var Data = JSON.stringify(response);  
                  var Data2 = JSON.parse(Data) ; 
                  sessionStorage.setItem("service_banking_auth", Data2["Authorisation"].auth);
	sessionStorage.setItem("service_banking_accesscode", Data2["Authorisation"].accesscode); 
  sessionStorage.setItem("service_banking_uid", Data2["Authorisation"].uid);    
  CheckCounter++ ;
                }else{
                  sessionStorage.setItem("service_banking_auth","");
                  sessionStorage.setItem("service_banking_accesscode", "");  
                  CheckCounter++ ;


                }
              //  $("#message").html(msg);
            }
        });
  


}
  function Callservice_virtual(){

    let service_virtual_base = sessionStorage.getItem("service_virtual_base");
let service_virtual_authEndPoint = sessionStorage.getItem("service_virtual_authEndPoint");

    var email = $("#email").val().trim();
        var password = $("#password").val().trim();
            $.ajax({
                url:service_virtual_base+service_virtual_authEndPoint,
                contentType: 'application/json' ,
                dataType: 'json',
                type:'post',
                data: JSON.stringify( { "Rehoboth_Api_Email": email, "Rehoboth_Api_Password": password } ),
                success:function(response){
                  
                  console.log(response) ;
            
                   // alert("error2"+response.error) ;
                    if(!response.error){
                      var Data = JSON.stringify(response);  
                  var Data2 = JSON.parse(Data) ; 
                  sessionStorage.setItem("service_virtual_auth", Data2["Authorisation"].auth);
	sessionStorage.setItem("service_virtual_accesscode", Data2["Authorisation"].accesscode);     
  CheckCounter++ ;  
                   
                    }else{
                      sessionStorage.setItem("service_virtual_auth", "");
                      sessionStorage.setItem("service_virtual_accesscode", "");   
                         CheckCounter++ ;
 
    
                    }
                  //  $("#message").html(msg);
                }
            });
      


  }
  </script>
  <!-- end scripts-->

  <!-- Prompt IE 6 users to install Chrome Frame. Remove this if you want to support IE 6.
       chromium.org/developers/how-tos/chrome-frame-getting-started -->
  <!--[if lt IE 7 ]>
    <script src="//ajax.googleapis.com/ajax/libs/chrome-frame/1.0.3/CFInstall.min.js"></script>
    <script>window.attachEvent('onload',function(){CFInstall.check({mode:'overlay'})})</script>
  <![endif]-->
  
</body>
</html>
